<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Faq;
use App\Models\Testimony;

class ApiController extends Controller
{
    //
    public function faqs(Request $request)
    {
    	$faqs = $request->limit ? Faq::limit($request->limit)->get() : Faq::all();
    	return response()->json($faqs);
    }
    //
    public function testimonials(Request $request)
    {
    	$testimonials = $request->limit ? Testimony::inRandomOrder()->limit($request->limit)->get() : Testimony::inRandomOrder()->get();
    	return response()->json($testimonials);
    }
}
