<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Plan;
use App\Models\Faq;
use App\Models\Testimony;
use App\Models\TpTransaction;

class HomeController extends Controller
{
    //
    public function index()
    {
    	return view('index')->with([
            'faqs' => Faq::limit(5)->get(),
            'testimonials' => Testimony::limit(5)->get(),
            'transactions' => TpTransaction::leftJoin("users", "users.id", "=", "tp__transactions.user")
                                ->select([
                                    'users.name as name',
                                    'tp__transactions.amount as amount',
                                    'tp__transactions.type as type',
                                ])
                                ->orderBy("tp__transactions.id", "desc")
                                ->where("tp__transactions.type", "=", "Deposit")
                                ->orWhere("tp__transactions.type", "=", "Withdrawal")
                                ->limit(10)
                                ->get()
        ]);
    }

    //
    public function about()
    {
    	return view('about')->with([
            'faqs' => Faq::limit(5)->get()
        ]);
    }

    //
    public function investment_plan()
    {
    	return view('investment_plan')->with([
            'faqs' => Faq::limit(5)->get(),
            'plans' => Plan::all()
        ]);
    }

    //
    public function faq()
    {
    	return view('faq')->with([
            'faqs' => Faq::all()
        ]);
    }

    //
    public function policy()
    {
    	return view('policy');
    }

    //
    public function legal()
    {
    	return view('legal');
    }
}
