<?php

/**
 * This is my custom helper function
 * Laravel keeps resetting it's global helper file
 * So I opened a new file of my own, damn you Laravel!
 */

use App\Models\Control\GeneralSetting;
use App\Utilities\RandomGenerator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Models\Deposit;
use App\Models\Withdrawal;
use App\Models\Plan;
use App\Models\User;
use App\Models\TpTransaction;
use App\Models\UserPlan;
use App\Models\Setting;
use App\Models\Notification;

if (! function_exists('generate_random_string')) {
    /**
     * @param $length
     * @return string
     */
    function generate_random_string($length)
    {
        return RandomGenerator::generate_random_string($length);
    }
}

if (! function_exists('generate_random_numbers')) {
    /**
     * @param $length
     * @return string
     */
    function generate_random_numbers($length)
    {
        return RandomGenerator::generate_random_numbers($length);
    }
}

if(! function_exists('toast')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function toast($type, $body)
    {
        session()->flash('message', [
            'type' => $type,
            'body' => $body
        ]);
    }
}

if(! function_exists('app_url')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function app_url()
    {
        return 'http://castledigital';
    }
}

if(! function_exists('app_name')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function app_name($check = NULL)
    {
        return $check ? 'Castle Digital' : 'CastleDigital';
    }
}

if(! function_exists('app_email')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function app_email()
    {
        return 'castledigital@gmail.com';
        //return 'udemezueobiajulu@gmail.com';
    }
}

if(! function_exists('admin_email')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function admin_email()
    {
        return 'obi4biz@gmail.com';
    }
}

if(! function_exists('user')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function user()
    {
        return \Auth::guard('web')->user();
    }
}

if(! function_exists('admin')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function admin()
    {
        return \Auth::guard('admin')->user();
    }
}

if(! function_exists('current_route')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function current_route()
    {
        return \Request::route()->getName();
    }
}

if(! function_exists('alert_type')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function alert_type($type)
    {
        if($type == 'error'){
            return 'danger';
        }
        else{
            return $type;
        }
    }
}

if(! function_exists('alert_icon')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function alert_icon($type)
    {
        if($type == 'error'){
            return 'times';
        }
        elseif($type == 'info'){
            return 'info';
        }
        elseif($type == 'success'){
            return 'check';
        }
        else{
            return 'exclamation-triangle';
        }
    }
}

if(! function_exists('total_deposit')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function total_deposit()
    {
        $deposits = Deposit::where("status", "Processed")->sum("amount");
        return $deposits;
    }
}

if(! function_exists('pending_deposit')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function pending_deposit()
    {
        $pending_deposits = Deposit::where("status", "Pending")->sum("amount");
        return $pending_deposits;
    }
}

if(! function_exists('total_withdrawal')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function total_withdrawal()
    {
        $withdrawals = Withdrawal::where("status", "Processed")->sum("amount");
        return $withdrawals;
    }
}

if(! function_exists('pending_withdrawal')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function pending_withdrawal()
    {
        $pending_withdrawals = Withdrawal::where("status", "Pending")->sum("amount");
        return $pending_withdrawals;
    }
}

if(! function_exists('total_users')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function total_users()
    {
        $users = count(User::all());
        return $users;
    }
}

if(! function_exists('blocked_users')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function blocked_users()
    {
        $users = count(User::where("status", "blocked")->get());
        return $users;
    }
}

if(! function_exists('active_users')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function active_users()
    {
        $users = count(User::where("status", "active")->get());
        return $users;
    }
}

if(! function_exists('total_investment_plans')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function total_investment_plans()
    {
        $plans = count(Plan::all());
        return $plans;
    }
}

if(! function_exists('user_deposit')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function user_deposit($id = NULL)
    {
        $deposits = Deposit::where("user", $id ?? user()->id)->sum("amount");
        return $deposits;
    }
}

if(! function_exists('user_packages')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function user_packages($id = NULL)
    {
        $packages = UserPlan::where("user", $id ?? user()->id)->sum("amount");
        return $packages;
    }
}

if(! function_exists('user_active_packages')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function user_active_packages($id = NULL)
    {
        $packages = UserPlan::where("user", $id ?? user()->id)->where("active", "yes")->sum("amount");
        return $packages;
    }
}

if(! function_exists('dwt')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function dwt()
    {
        $deposits = Deposit::where("status", "Processed")->sum("amount");
        $pending_deposits = Deposit::where("status", "Pending")->sum("amount");
        $withdrawals = Withdrawal::where("status", "Processed")->sum("amount");
        $pending_withdrawals = Withdrawal::where("status", "Pending")->sum("amount");
        $tp_transactions = TpTransaction::sum("amount");
        return "[". round($deposits, 2) .", ". round($pending_deposits, 2) .", ". round($withdrawals, 2) .", ". round($pending_withdrawals, 2) .", ". round($tp_transactions, 2) ."]";
    }
}

if(! function_exists('image_url')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function image_url($avatar)
    {
        return app_url().'/storage/'.$avatar;
    }
}

if(! function_exists('get_hours')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function get_hours($value)
    {
        if($value == "Hourly"){
            return 1;
        }
        elseif($value == "Daily"){
            return 24;
        }
        elseif($value == "Daily"){
            return 24;
        }
        elseif($value == "Weekly"){
            return 168;
        }
        elseif($value == "Monthly"){
            return 720;
        }
        elseif($value == "One Week"){
            return 168;
        }
        elseif($value == "One Month"){
            return 720;
        }
        elseif($value == "Three Months"){
            return 2160;
        }
        elseif($value == "Six Months"){
            return 4320;
        }
        elseif($value == "One Year"){
            return 8640;
        }
        else{
            return 0;
        }
    }
}

if(! function_exists('get_payment_mode_key')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function get_payment_mode_key($value)
    {
        if($value == "Bitcoin"){
            return 'btc_address';
        }
        elseif($value == "Etherium"){
            return 'eth_address';
        }
        elseif($value == "Litecoin"){
            return 'ltc_address';
        }
        elseif($value == "Dodgecoin"){
            return 'dodge_address';
        }
        elseif($value == "BNB"){
            return 'bnb_address';
        }
        else{
            return '';
        }
    }
}

if(! function_exists('minimum_withdrawal')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function minimum_withdrawal()
    {
        $setting = Setting::first();
        return $setting->minimum_withdrawal;
    }
}

if(! function_exists('maximum_withdrawal')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function maximum_withdrawal()
    {
        $setting = Setting::first();
        return $setting->maximum_withdrawal;
    }
}

if(! function_exists('withdrawal_charge_percent')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function withdrawal_charge_percent()
    {
        $setting = Setting::first();
        return $setting->withdrawal_charge_percent;
    }
}

if(! function_exists('withdrawal_charge_amount')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function withdrawal_charge_amount($amount)
    {
        return number_format((($amount/100)*withdrawal_charge_percent()), 2, '.', ',');
    }
}

if(! function_exists('credit_investment')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function credit_investment()
    {
        $investments = UserPlan::leftJoin("plans", "plans.id", "=", "user_plans.plan")
                            ->select([
                                'plans.name as plan',
                                'user_plans.user as user',
                                'user_plans.expire_date as expire_date',
                                'user_plans.amount as amount',
                                'user_plans.shares as shares',
                                'user_plans.last_growth as last_growth',
                                'user_plans.tinterval as tinterval',
                                'user_plans.inv_duration as inv_duration',
                            ])
                            ->where("user_plans.expire_date", "!=", NULL)
                            ->where("user_plans.active", "yes")
                            ->get();

        foreach($investments as $investment){
            //check if the investment has expired

            $user = User::where("id", $investment->user)->first();

            if(Carbon::now() > $investment->expire_date){
                //add one more roi before terminating the investment
                if($user){
                    //increment balance and roi and also return the initial investment amount
                    $increment = ($investment->amount/100) * $investment->shares;
                    $user->update([
                        'account_bal' => $user->account_bal + $increment + $investment->amount,
                        'roi' => $user->roi + $increment,
                    ]);

                    //terminate the investment
                    $investment->update([
                        'active' => 'expired',
                        'last_growth' => Carbon::now()
                    ]);

                    //add transaction
                    TpTransaction::create([
                        'user' => $user->id,
                        'amount' => $increment,
                        'type' => 'ROI',
                    ]);

                    //notify the user
                    $message = "Your investment of $" . number_format($investment->amount, 2, '.', ',') . " in " . $investment->plan . " Plan for a period of " . $investment->inv_duration . " has been completed sucessfully";
                    notify($message, $user->id);
                }
            }
            else{
                //check if the interval is met and add roi
                if(Carbon::now() > Carbon::parse($investment->last_growth)->addHours(get_hours($investment->tinterval))){

                    //increment balance and roi and also return the initial investment amount
                    $increment = ($investment->amount/100) * $investment->shares;
                    $user->update([
                        'account_bal' => $user->account_bal + $increment,
                        'roi' => $user->roi + $increment,
                    ]);

                    //update lat groeth
                    $investment->update([
                        'last_growth' => Carbon::now()
                    ]); 

                    //add transaction
                    TpTransaction::create([
                        'user' => $user->id,
                        'amount' => $increment,
                        'type' => 'ROI',
                    ]);
                }
            }
        }
    }
}

if(! function_exists('notifications')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function notifications()
    {
        $notifications = Notification::where("user_id", user()->id)->where("has_seen", NULL)->get();
        return count($notifications);
    }
}

if(! function_exists('notify')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function notify($message, $user_id = NULL)
    {
        Notification::create([
            'user_id' => $user_id ?? user()->id,
            'message' => $message,
        ]);
    }
}

if(! function_exists('to_time')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function to_time($string)
    {
        $time = Carbon::parse($string)->format('d m Y H:i');
        return $time;
    }
}

if(! function_exists('enable_2fa')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function enable_2fa()
    {
        $setting = Setting::first();
        return $setting->enable_2fa;
    }
}

if(! function_exists('enable_verification')) {
    /**
     * @param $title
     * @param $type
     * @param $body
     */
    function enable_verification()
    {
        $setting = Setting::first();
        return $setting->enable_verification;
    }
}