/* Global jQuery */

/* Contents
// ------------------------------------------------>
     1. wow animation
     2. Menu Mobile
     3. Cart
     4. Search
     5. Owl Slider
     6. Light Box
     7. Fixed Header
     8. Sticky Sidebar
*/

(function ($) {
    "use strict";

    /* Header Search */
    var $search_btn = $('header li.search-btn a'),
        $search_box = $('header .search-box');
    $search_btn.on("click", function (e) {
        $search_box.slideToggle();
    });



    /* ------------------  1.Owl Slider ------------------ */
    var owl = $(".testimonial-slider");
    var owl1 = $(".client-slider");
    var owl2 = $(".main-slider");
    var owl3 = $(".portfolio-slider");

    owl.owlCarousel({
        slideSpeed: 1000,
        autoPlay: true,
        loop: true,
        nav: true,
        dots: true,
        navText: ["<span class='arrow-left'></span>", "<span class='arrow-right'></span>"],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });

    owl1.owlCarousel({
        slideSpeed: 1000,
        autoPlay: true,
        loop: true,
        nav: false,
        dots: false,
        responsive: {
            0: {
                items: 2
            },
            600: {
                items: 4
            },
            1000: {
                items: 6
            }
        }
    });

    owl2.owlCarousel({
        slideSpeed: 1000,
        autoPlay: true,
        loop: true,
        nav: true,
        dots: true,
        navText: ["<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>"],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });

    owl3.owlCarousel({
        center: true,
        items: 1,
        loop: true,
        margin: 0,
        dots: true,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 4
            },
            1000: {
                items: 4
            }
        }
    });



    /* ------------------  Mobile Menu ------------------ */
    var $menu_show = $('.mobile-menu-show'),
        $menu = $('header #mobile-menu'),
        $list_mobile = $("ul#mobile-menu.nav-mobile-menu li a"),
        $menu_ul_mobile = $('ul.sub-menu');

    $menu_show.on("click", function (e) {
        $menu.slideToggle();
    });



    $list_mobile.on("click", function (e) {
        var submenu = this.parentNode.getElementsByTagName("ul").item(0);
        if (submenu != null) {
            event.preventDefault();
            $(submenu).slideToggle();
        }
    });



    /* ------------------  2.Go Top ------------------ */
    var btn = $('#nile-go-top');
    $(window).scroll(function () {
        if ($(window).scrollTop() > 300) {
            btn.addClass('show');
        } else {
            btn.removeClass('show');
        }
    });

    btn.on('click', function (e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, '300');
    });


    /* ------------------  3.Hide sidebar ------------------ */
    var $sidebar_bottom = $(".sidebar-var-link"),
        $body = $("body"),
        $close_sidebar = $(".close-nile-sidebar"),
        $sidebar_in = $(".nile-sidebar");
    $sidebar_bottom.on("click", function (e) {
        $sidebar_in.addClass("open");
        $close_sidebar.addClass("open");
        $body.css('overflow', 'hidden');
    });

    $close_sidebar.on("click", function (e) {
        $sidebar_in.removeClass("open");
        $(this).removeClass("open");
        $body.css('overflow', 'auto');
    });
    /* ------------------  3.Shop cart ------------------ */
    var $sidebar_bottom_shop_cart = $(".btn-shopping-basket"),
        $close_sidebar_shop_cart = $(".close-shop-cart"),
        $sidebar_in_shop_cart = $(".nile-shop-cart");

    $sidebar_bottom_shop_cart.on("click", function (e) {
        $sidebar_in_shop_cart.addClass("open");
        $close_sidebar_shop_cart.addClass("open");
        $body.css('overflow', 'hidden');
    });

    $close_sidebar_shop_cart.on("click", function (e) {
        $sidebar_in_shop_cart.removeClass("open");
        $(this).removeClass("open");
        $body.css('overflow', 'auto');
    });



    var current = location.pathname;
    $('.services-menu li a').each(function () {
        var $this = $(this);
        // if the current path is like this link, make it active
        if ($this.attr('href').indexOf(current) !== -1) {
            $this.addClass('active');
        }
    })

    /* ------------------  5.Mobile Menu ------------------ */
    var
        $body_mobile = $("body"),
        $close_sidebar_mobile = $(".close-nile-header-menu"),
        $sidebar_in_mobile = $(".nile-header-menu");

    $('.nav-menu-mobile > li.has-dropdown').click(function (e) {
        $(this).next('.sub-menu').slideToggle();
    });



    $(".excerpt-50 p").text(function (index, currentText) {
        return currentText.substr(0, 160);
    });
    $(".excerpt-50").text(function (index, currentText) {
        return currentText.substr(0, 160);
    });





}(jQuery));
