@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Manage Administrators</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <a href="javascript:void(0)" class="btn btn-primary mb-4" data-toggle="modal" data-target="#addadministratorModal">Add Administrator</a>
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="toolbar">
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                    </div>
                                    <form class="flex" action="">
                                        <div class="input-group">
                                            <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="{{ $search }}" />
                                            <span class="input-group-append">
                                                <button class="btn btn-white no-border btn-sm" type="submit">
                                                    <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                </button>
                                            </span>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">First Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Last Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Email</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Phone</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Type</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Status</th>
                                                <th style="width: 50px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            @if($administrators)
                                                @foreach($administrators as $administrator)
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted">{{ $administrator->id }}</small></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted">{{ $administrator->firstName }}</span></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted">{{ $administrator->lastName }}</span></td>
                                                    <td class="no-wrap"><div class="item-date text-muted text-sm">{{ $administrator->email }}</div></td>
                                                    <td><span class="item-amount text-muted text-sm">{{ $administrator->phone }}</span></td>
                                                    <td><span class="item-amount text-muted text-sm">{{ $administrator->type }}</span></td>
                                                    <td><span class="item-amount text-muted text-sm">{{ $administrator->status }}</span></td>
                                                    <td>
                                                        <div class="item-action dropdown">
                                                            <a href="#" data-toggle="dropdown" class="text-muted"><i data-feather="more-vertical"></i></a>
                                                            <div class="dropdown-menu dropdown-menu-right bg-black" role="menu">
                                                                <a class="dropdown-item text-danger d-{{ $administrator->status != 'active' ? 'none' : NULL }}" href="{{ route('admin.administrator_block', $administrator->id) }}">Block</a>
                                                                <a class="dropdown-item text-success d-{{ $administrator->status == 'active' ? 'none' : NULL }}" href="{{ route('admin.administrator_activate', $administrator->id) }}">Activate</a>
                                                                <a class="dropdown-item text-warning" href="javascript:void(0)" data-toggle="modal" data-target="#passwordModal-{{ $administrator->id }}">Reset password</a>
                                                                <a class="dropdown-item text-danger" href="{{ route('admin.administrator_delete', $administrator->id) }}" onclick="return confirm('are you sure you want to delete this administrator? this operation cannot be rolled back')">Delete</a>
                                                                <a class="dropdown-item text-primary" href="javascript:void(0)" data-toggle="modal" data-target="#editModal-{{ $administrator->id }}">Edit</a>
                                                                <a class="dropdown-item text-info" href="javascript:void(0)" data-toggle="modal" data-target="#messageModal-{{ $administrator->id }}">Send message</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                <div id="passwordModal-{{ $administrator->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Reset administrator Password</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.administrator_reset_password') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $administrator->id }}">
                                    <div class="form-group">
                                        <label>Are you sure you want to reset password for {{ $administrator->name }} to <a href="#">admin01236</a></label>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Reset Password</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="editModal-{{ $administrator->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Edit Administrator</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.administrator_edit') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $administrator->id }}">
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input class="form-control" type="text" name="firstName" placeholder="Enter firstname" value="{{ $administrator->firstName }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input class="form-control" type="text" name="lastName" placeholder="Enter lastname" value="{{ $administrator->lastName }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input class="form-control" type="text" name="email" placeholder="Enter email" value="{{ $administrator->email }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Phone Number</label>
                                        <input class="form-control" type="text" name="phone" placeholder="Enter phone" value="{{ $administrator->phone }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Type</label>
                                        <select autocomplete="off" class="form-control" type="text" name="type" placeholder="Enter phone" value="{{ $administrator->type }}">
                                            <option @if($administrator->type == "Admin") selected @endif value="Admin">Admin</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="messageModal-{{ $administrator->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Send Mail to {{ $administrator->name }}</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.administrator_mail') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $administrator->id }}">
                                    <div class="form-group">
                                        <label>Message</label>
                                        <textarea class="form-control" type="text" name="message" placeholder="Type your message here"></textarea>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                @if($administrators)
                                    {{ $administrators->withQueryString()->links() }}
                                @endif
                            </div>
                            <!-- / .modal -->
                            <div id="addadministratorModal" class="modal fade" data-backdrop="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <div class="modal-title text-md">Add New Administrator</div>
                                            <button class="close" data-dismiss="modal">&times;</button>
                                        </div>
                                        <div class="modal-body">
                                            <form method="post" action="{{ route('admin.administrator_add') }}">
                                                @csrf
                                                <div class="form-group">
                                                    <label>First Name</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="firstName" placeholder="Enter firstname">
                                                </div>
                                                <div class="form-group">
                                                    <label>Last Name</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="lastName" placeholder="Enter lastname">
                                                </div>
                                                <div class="form-group">
                                                    <label>Email</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="email" placeholder="Enter email">
                                                </div>
                                                <div class="form-group">
                                                    <label>Phone Number</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="phone" placeholder="Enter phone">
                                                </div>
                                                <div class="form-group">
                                                    <label>Type</label>
                                                    <select autocomplete="off" class="form-control" type="text" name="type" placeholder="Enter phone">
                                                        <option value="Admin">Admin</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label>Password</label>
                                                    <input autocomplete="new-password" class="form-control" type="password" name="password" placeholder="Enter password">
                                                </div>
                                                <div class="form-group">
                                                    <label>Confirm Password</label>
                                                    <input autocomplete="new-password" class="form-control" type="password" name="confirm_password" placeholder="Confirm password">
                                                </div>
                                                <div class="form-group">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection