@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">{{ $user->name }} clients</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Client Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Clients Inv Plan</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Clients Status</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Earnings</th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            @if($clients)
                                                @foreach($clients as $client)
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted">{{ $client->id }}</small></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted">{{ $client->name }}</span></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted">{{ $client->plan }}</span></td>
                                                    <td><div class="item-date text-muted text-sm">{{ $client->status }}</div></td>
                                                    <td><div class="item-date text-muted text-sm">${{ number_format($client->amount, 2, '.', ',') }}</div></td>
                                                </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                @if($clients)
                                    {{ $clients->withQueryString()->links() }}
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection