@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Manage Agents</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <a href="javascript:void(0)" class="btn btn-primary mb-4" data-toggle="modal" data-target="#newAgentModal">Add new agent</a>
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="toolbar">
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                    </div>
                                    <form class="flex" action="">
                                        <div class="input-group">
                                            <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="{{ $search }}" />
                                            <span class="input-group-append">
                                                <button class="btn btn-white no-border btn-sm" type="submit">
                                                    <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                </button>
                                            </span>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Agent Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Clients Referred</th>
                                                <th style="width: 50px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            @if($agents)
                                                @foreach($agents as $agent)
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted">{{ $agent->id }}</small></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted">{{ $agent->name }}</span></td>
                                                    <td class="no-wrap"><div class="item-date text-muted text-sm">{{ $agent->total_refered }}</div></td>
                                                    <td>
                                                        <div class="item-action dropdown">
                                                            <a href="#" data-toggle="dropdown" class="text-muted"><i data-feather="more-vertical"></i></a>
                                                            <div class="dropdown-menu dropdown-menu-right bg-black" role="menu">
                                                                <a class="dropdown-item" href="{{ route('admin.agent_clients', $agent->user_id) }}">View Clients</a>
                                                                <a class="dropdown-item text-danger" href="{{ route('admin.agent_delete', $agent->id) }}" onclick="return confirm('are you sure you want to delete this agent?')">Delete</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                @if($agents)
                                    {{ $agents->withQueryString()->links() }}
                                @endif
                            </div>
                            <!-- .modal -->
                            <div id="newAgentModal" class="modal fade" data-backdrop="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header"><h5 class="modal-title">New Agent</h5></div>
                                        <div class="modal-body p-4">
                                            <form method="post" action="{{ route('admin.agent_add') }}">
                                                @csrf
                                                <div class="form-group">
                                                    <label>Select User</label>
                                                    <select class="form-control" type="text" name="agent">
                                                        @if($users)
                                                            @foreach($users as $user)
                                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label>Total Refererd</label>
                                                    <input class="form-control" type="number" name="total_refered" placeholder="Increment total referred">
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection