@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Dashboard</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="row row-sm sr">
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-download fa-2x text-warning"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Total Deposit</div>
                                                    <p class="text-secondary mt-2">${{ number_format(total_deposit(), 2, '.', ',') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-cloud-download fa-2x text-info"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Pending Deposits</div>
                                                    <p class="text-secondary mt-2">${{ number_format(pending_deposit(), 2, '.', ',') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-share-square fa-2x text-danger"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Total Withdrawal</div>
                                                    <p class="text-secondary mt-2">${{ number_format(total_withdrawal(), 2, '.', ',') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-share fa-2x text-primary"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Pending Withdrawals</div>
                                                    <p class="text-secondary mt-2">${{ number_format(pending_withdrawal(), 2, '.', ',') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-users fa-2x text-success"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Total Users</div>
                                                    <p class="text-secondary mt-2">{{ total_users() }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-user-minus fa-2x text-danger"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Blocked Users</div>
                                                    <p class="text-secondary mt-2">{{ blocked_users() }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-user-plus fa-2x text-success"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Active Users</div>
                                                    <p class="text-secondary mt-2">{{ active_users() }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex">
                                    <div class="card flex">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center text-hover-success">
                                                <div class="avatar w-56 m-2 no-shadow"><i class="fas fa-sitemap fa-2x text-warning"></i></div>
                                                <div class="px-4 flex">
                                                    <div>Investment Plans</div>
                                                    <p class="text-secondary mt-2">{{ total_investment_plans() }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" data-plugin="chartjs">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">Statistics</div>
                                        <div class="card-body" style="height: 240px;"><canvas id="chart-bar"></canvas></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection