@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Manage Images</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <a href="javascript:void(0)" class="btn btn-primary mb-4" data-toggle="modal" data-target="#addimageModal">Add Image</a>
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="toolbar">
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                    </div>
                                    <form class="flex" action="">
                                        <div class="input-group">
                                            <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="{{ $search }}" />
                                            <span class="input-group-append">
                                                <button class="btn btn-white no-border btn-sm" type="submit">
                                                    <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                </button>
                                            </span>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Image</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Ref Key</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Title</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Description</th>
                                                <th style="width: 50px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            @if($images)
                                                @foreach($images as $image)
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted">{{ $image->id }}</small></td>
                                                    <td><img src="{{ image_url($image->img_path) }}" width="100" /></td>
                                                    <td><span class="item-amount text-muted text-sm">{{ $image->ref_key }}</span></td>
                                                    <td><span class="item-amount text-muted text-sm">{{ $image->title }}</span></td>
                                                    <td><span class="item-amount text-muted text-sm">{{ $image->description }}</span></td>
                                                    <td>
                                                        <div class="item-action dropdown">
                                                            <a href="#" data-toggle="dropdown" class="text-muted"><i data-feather="more-vertical"></i></a>
                                                            <div class="dropdown-menu dropdown-menu-right bg-black" role="menu">
                                                                <a class="dropdown-item text-danger" href="{{ route('admin.image_delete', $image->id) }}" onclick="return confirm('are you sure you want to delete this image? this operation cannot be rolled back')">Delete</a>
                                                                <a class="dropdown-item text-primary" href="javascript:void(0)" data-toggle="modal" data-target="#editModal-{{ $image->id }}">Edit</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                <div id="editModal-{{ $image->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Edit image</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.image_edit') }}" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $image->id }}">
                                    <div class="form-group">
                                        <label>Ref Key</label>
                                        <input class="form-control" type="text" name="ref_key" placeholder="Enter ref key" value="{{ $image->ref_key }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Title</label>
                                        <input class="form-control" type="text" name="title" placeholder="Enter title" value="{{ $image->title }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" type="text" name="description" placeholder="Enter description">{{ $image->description }}</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Image</label>
                                        <input class="form-control" type="file" name="img_path" placeholder="Enter question" accept=".png,.jpg">
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                @if($images)
                                    {{ $images->withQueryString()->links() }}
                                @endif
                            </div>
                            <!-- / .modal -->
                            <div id="addimageModal" class="modal fade" data-backdrop="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <div class="modal-title text-md">Add New image</div>
                                            <button class="close" data-dismiss="modal">&times;</button>
                                        </div>
                                        <div class="modal-body">
                                            <form method="post" action="{{ route('admin.image_add') }}" enctype="multipart/form-data">
                                                @csrf
                                                <div class="form-group">
                                                    <label>Ref Key</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="ref_key" placeholder="Enter ref key">
                                                </div>
                                                <div class="form-group">
                                                    <label>Title</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="title" placeholder="Enter title">
                                                </div>
                                                <div class="form-group">
                                                    <label>Description</label>
                                                    <textarea autocomplete="off" class="form-control" type="text" name="description" placeholder="Enter description"></textarea>
                                                </div>
                                                <div class="form-group">
                                                    <label>Image</label>
                                                    <input autocomplete="off" class="form-control" type="file" name="img_path" placeholder="Enter question" accept=".png,.jpg">
                                                </div>
                                                <div class="form-group">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection