<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>{{ app_name('separated') }}</title>
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <!-- style -->
        <link rel="icon" type="img/png" href="https://crestsvalue.com/wp-content/uploads/2021/04/rex-png-1-6.pngj">
        <link rel="stylesheet" href="/assets/css/site.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    </head>
    <body class="layout-row">
        <div class="flex">
            <div class="w-xl w-auto-sm mx-auto py-5">
                @include('admin.alert')
                <div class="p-4 d-flex flex-column h-100">
                    <!-- brand -->
         
                    <!-- / brand -->
                </div>
                <div class="card">
                    <div id="content-body">
                        <div class="p-3 p-md-5">
                            <h5>Welcome back</h5>
                            <p><small class="text-muted">Login to manage your account</small></p>
                            <form method="post" role="form" action="{{ route('admin.login_post') }}">
                                @csrf
                                <div class="form-group">
                                    <label>Email</label>
                                    <input autocomplete="off" type="email" name="email" class="form-control" placeholder="Enter email" />
                                </div>
                                <div class="form-group">
                                    <label>Password</label>
                                    <input autocomplete="new-password" type="password" name="password" class="form-control" placeholder="Password" />
                                </div>
                            
                                <button type="submit" class="btn btn-primary mb-4">Sign in</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center text-muted">&copy; Copyright. {{ app_name('separated') }}</div>
            </div>
        </div>
        <script src="/assets/js/site.min.js"></script>
    </body>
</html>
