@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Available Plan</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <button data-toggle="modal" data-target="#addModal" class="btn btn-primary mb-2"><i class="fas fa-plus"></i> Add new plan</button>
                            <div class="row">
                                @if($plans)
                                    @foreach($plans->sortBy("price") as $plan)
                                        <div class="col-sm-6">
                                            <div class="card" style="box-shadow: 4px #000000;">
                                                <div class="card-body">
                                                    <h5 class="card-title text-center text-success">{{ $plan->name }}</h5>
                                                    <h2 class="card-title text-center">${{ number_format($plan->price, 2, '.', ',') }}</h2>
                                                </div>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Possible Deposit:</span> <span>${{ number_format($plan->min_price, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Possible Deposit:</span> <span>${{ number_format($plan->max_price, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Return:</span> <span>${{ number_format($plan->minr, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Return:</span> <span>${{ number_format($plan->maxr, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Gift Bonus:</span> <span>{{ $plan->gift }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Duration:</span> <span>{{ $plan->expiration }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Increment Interval:</span> <span>{{ $plan->increment_interval }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Percentage Increase:</span> <span>{{ $plan->increment_amount }}%</span></li>
                                                </ul>
                                                <div class="card-body text-center">
                                                    <a data-toggle="modal" data-target="#editModal-{{ $plan->id }}" href="javascript:void(0)" class="btn btn-primary btn-md"><i class="fas fa-edit"></i></a> 
                                                    <a onclick="return confirm('are you sure you want to delete this plan?')" href="{{ route('admin.plan_delete', $plan->id) }}" class="btn btn-danger btn-md"><i class="fas fa-times"></i></a>
                                                </div>
                                            </div>
                                        </div>
                <div id="editModal-{{ $plan->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Edit Plan</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.plan_edit') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $plan->id }}">
                                    <div class="form-group">
                                        <label>Plan Name</label>
                                        <input class="form-control" type="text" name="name" placeholder="Enter Plan name" value="{{ $plan->name }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Price</label>
                                        <input class="form-control" type="text" name="price" placeholder="Enter Plan price" value="{{ $plan->price }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Minimum Price</label>
                                        <input class="form-control" type="text" name="min_price" placeholder="Enter Plan minimum price" value="{{ $plan->min_price }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Maximum Price</label>
                                        <input class="form-control" type="text" name="max_price" placeholder="Enter Plan maximum price" value="{{ $plan->max_price }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Minimum Return</label>
                                        <input class="form-control" type="text" name="minr" placeholder="Enter Plan minimum return" value="{{ $plan->minr }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Maximum Return</label>
                                        <input class="form-control" type="text" name="maxr" placeholder="Enter Plan maximum return" value="{{ $plan->maxr }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Gift Bonus</label>
                                        <input class="form-control" type="text" name="gift" placeholder="Enter Gift bonus" value="{{ $plan->gift }}">
                                    </div>
                                    <div class="form-group">
                                        <label>To Up Interval</label>
                                        <select class="form-control" type="text" name="increment_interval" value="{{ $plan->increment_interval }}">
                                            <option @if($plan->increment_interval == 'Monthly') selected @endif value="Monthly">Monthly</option>
                                            <option @if($plan->increment_interval == 'Weekly') selected @endif value="Weekly">Weekly</option>
                                            <option @if($plan->increment_interval == 'Daily') selected @endif value="Daily">Daily</option>
                                            <option @if($plan->increment_interval == 'Hourly') selected @endif value="Hourly">Hourly</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>To Up Type</label>
                                        <select class="form-control" type="text" name="increment_type" value="{{ $plan->increment_type }}">
                                            <option @if($plan->increment_type == 'Percentage') selected @endif value="Percentage">Percentage</option>
                                            <option @if($plan->increment_type == 'Fixed') selected @endif value="Fixed">Fixed</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Top Up Amount (in % or $ as specified above)</label>
                                        <input class="form-control" type="number" step="any" name="increment_amount" placeholder="Enter top up amount" value="{{ $plan->increment_amount }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Investment Duration</label>
                                        <select class="form-control" type="text" name="expiration" value="{{ $plan->expiration }}">
                                            <option @if($plan->expiration == 'One Week') selected @endif value="One Week">One Week</option>
                                            <option @if($plan->expiration == 'One Month') selected @endif value="One Month">One Month</option>
                                            <option @if($plan->expiration == 'Three Months') selected @endif value="Three Months">Three Months</option>
                                            <option @if($plan->expiration == 'Six Months') selected @endif value="Six Months">Six Months</option>
                                            <option @if($plan->expiration == 'One Year') selected @endif value="One Year">One Year</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Update Plan</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                    <div id="addModal" class="modal fade" data-backdrop="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <div class="modal-title text-md">Add Plan</div>
                                    <button class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="{{ route('admin.plan_add') }}">
                                        @csrf
                                        <div class="form-group">
                                            <label>Plan Name</label>
                                            <input class="form-control" type="text" name="name" placeholder="Enter Plan name">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Price</label>
                                            <input class="form-control" type="text" name="price" placeholder="Enter Plan price">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Minimum Price</label>
                                            <input class="form-control" type="text" name="min_price" placeholder="Enter Plan minimum price">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Maximum Price</label>
                                            <input class="form-control" type="text" name="max_price" placeholder="Enter Plan maximum price">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Minimum Return</label>
                                            <input class="form-control" type="text" name="minr" placeholder="Enter Plan minimum return">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Maximum Return</label>
                                            <input class="form-control" type="text" name="maxr" placeholder="Enter Plan maximum return">
                                        </div>
                                        <div class="form-group">
                                            <label>Gift Bonus</label>
                                            <input class="form-control" type="text" name="gift" placeholder="Enter Gift bonus">
                                        </div>
                                        <div class="form-group">
                                            <label>To Up Interval</label>
                                            <select class="form-control" type="text" name="increment_interval">
                                                <option value="Monthly">Monthly</option>
                                                <option value="Weekly">Weekly</option>
                                                <option value="Daily">Daily</option>
                                                <option value="Hourly">Hourly</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>To Up Type</label>
                                            <select class="form-control" type="text" name="increment_type">
                                                <option value="Percentage">Percentage</option>
                                                <option value="Fixed">Fixed</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Top Up Amount (in % or $ as specified above)</label>
                                            <input class="form-control" type="number" step="any" name="increment_amount" placeholder="Enter top up amount">
                                        </div>
                                        <div class="form-group">
                                            <label>Investment Duration</label>
                                            <select class="form-control" type="text" name="expiration">
                                                <option value="One Week">One Week</option>
                                                <option value="One Month">One Month</option>
                                                <option value="Three Months">Three Months</option>
                                                <option value="Six Months">Six Months</option>
                                                <option value="One Year">One Year</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">Add Plan</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                    </div>
                </div>

@endsection