@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Manage Settings</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div id="accordion">
                                <p class="text-muted"><strong>Information</strong></p>
                                <div class="card">
                                    <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_2">
                                        <i data-feather="globe"></i>
                                        <div class="px-3"><div>Site Information</div></div>
                                        <div class="flex"></div>
                                        <div><i data-feather="chevron-right"></i></div>
                                    </div>
                                    <div class="collapse p-4" id="c_2">
                                        <form role="form" method="post" action="{{ route('admin.setting_edit') }}" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group"><label>Site Name</label><input type="text" class="form-control" name="site_name" value="{{ $setting->site_name }}" /></div>
                                            <div class="form-group"><label>Site Description</label><textarea type="text" class="form-control" name="description">{{ $setting->description }}</textarea></div>
                                            <div class="form-group"><label>Site Keywords</label><input type="text" class="form-control" name="keywords" value="{{ $setting->keywords }}" /></div>
                                            <div class="form-group"><label>Site Title</label><input type="text" class="form-control" name="site_title" value="{{ $setting->site_title }}" /></div>
                                            <div class="form-group"><label>Site Address</label><input type="text" class="form-control" name="site_address" value="{{ $setting->site_address }}" /></div>
                                            <div class="form-group"><label>Site Logo</label><input type="file" class="form-control" name="logo" accept=".jpg,.png,.ico" /></div>
                                            <div class="form-group"><label>Site Favicon</label><input type="file" class="form-control" name="favicon" accept=".jpg,.png,.ico" /></div>
                                            <div class="form-group"><label>Contact Email</label><input type="text" class="form-control" name="contact_email" value="{{ $setting->contact_email }}" /></div>
                                            <button type="submit" class="btn btn-primary mt-2">Update</button>
                                        </form>
                                    </div>
                                    <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_3">
                                        <i data-feather="credit-card"></i>
                                        <div class="px-3"><div>Wallet Information</div></div>
                                        <div class="flex"></div>
                                        <div><i data-feather="chevron-right"></i></div>
                                    </div>
                                    <div class="collapse p-4" id="c_3">
                                        <form role="form" method="post" action="{{ route('admin.setting_edit') }}" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group"><label>Bitcoin</label><input type="text" class="form-control" name="btc_address" value="{{ $setting->btc_address }}" /></div>
                                            <div class="form-group"><label>Etherium</label><input type="text" class="form-control" name="eth_address" value="{{ $setting->eth_address }}" /></div>
                                            <div class="form-group"><label>Litecoin</label><input type="text" class="form-control" name="ltc_address" value="{{ $setting->ltc_address }}" /></div>
                                            <div class="form-group"><label>Dodgecoin</label><input type="text" class="form-control" name="dodge_address" value="{{ $setting->dodge_address }}" /></div>
                                            <div class="form-group"><label>BNB</label><input type="text" class="form-control" name="bnb_address" value="{{ $setting->bnb_address }}" /></div>
                                            <button type="submit" class="btn btn-primary mt-2">Update</button>
                                        </form>
                                    </div>
                                    <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_4">
                                        <i data-feather="lock"></i>
                                        <div class="px-3"><div>Security Information</div></div>
                                        <div class="flex"></div>
                                        <div><i data-feather="chevron-right"></i></div>
                                    </div>
                                    <div class="collapse p-4" id="c_4">
                                        <form role="form" method="post" action="{{ route('admin.setting_edit') }}" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group"><label>Secrete Key</label><input type="text" class="form-control" name="s_s_k" value="{{ $setting->s_s_k }}" /></div>
                                            <div class="form-group"><label>Public Key</label><input type="text" class="form-control" name="s_p_k" value="{{ $setting->s_p_k }}" /></div>
                                            <div class="form-group"><label>Tawkto</label><input type="text" class="form-control" name="tawk_to" value="{{ $setting->tawk_to }}" /></div>
                                            <div class="form-group"><label>Files Key</label><input type="text" class="form-control" name="files_key" value="{{ $setting->files_key }}" /></div>
                                            <button type="submit" class="btn btn-primary mt-2">Update</button>
                                        </form>
                                    </div>
                                    <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_5">
                                        <i data-feather="plus-circle"></i>
                                        <div class="px-3"><div>Payment</div></div>
                                        <div class="flex"></div>
                                        <div><i data-feather="chevron-right"></i></div>
                                    </div>
                                    <div class="collapse p-4" id="c_5">
                                        <form role="form" method="post" action="{{ route('admin.setting_edit') }}" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group"><label>Signup Bonus</label><input type="number" class="form-control" name="signup_bonus" value="{{ $setting->signup_bonus }}" /></div>
                                            <div class="form-group"><label>Referral Commission</label><input type="number" step="any" class="form-control" name="referral_commission" value="{{ $setting->referral_commission }}" /></div>
                                            <div class="form-group"><label>Minimum Withdrawal</label><input type="number" step="any" class="form-control" name="minimum_withdrawal" value="{{ $setting->minimum_withdrawal }}" /></div>
                                            <div class="form-group"><label>Maximum Withdrawal</label><input type="number" step="any" class="form-control" name="maximum_withdrawal" value="{{ $setting->maximum_withdrawal }}" /></div>
                                            <div class="form-group"><label>Withdrawal Charge(%)</label><input type="number" step="any" class="form-control" name="withdrawal_charge_percent" value="{{ $setting->withdrawal_charge_percent }}" /></div>
                                            <button type="submit" class="btn btn-primary mt-2">Update</button>
                                        </form>
                                    </div>
                                </div>
                                <p class="text-muted"><strong>Preference</strong></p>
                                <div class="card">
                                    <form method="post" action="{{ route('admin.setting_edit') }}" id="preference_form">
                                    @csrf
                                    <div class="d-flex align-items-center px-4 py-3 b-t">
                                        <div>Enable 2factor Auth</div>
                                        <div class="flex"></div>
                                        <span>
                                            <label class="ui-switch ui-switch-md"><input name="enable_2fa" type="checkbox" @if($setting->enable_2fa == "yes") checked="checked" @endif /> <i></i></label>
                                        </span>
                                    </div>
                                    <div class="d-flex align-items-center px-4 py-3 b-t">
                                        <div>Enable KYC</div>
                                        <div class="flex"></div>
                                        <span>
                                            <label class="ui-switch ui-switch-md"><input name="enable_kyc" type="checkbox" @if($setting->enable_kyc == "yes") checked="checked" @endif /> <i></i></label>
                                        </span>
                                    </div>
                                    <div class="d-flex align-items-center px-4 py-3 b-t">
                                        <div>Enable Verification</div>
                                        <div class="flex"></div>
                                        <span>
                                            <label class="ui-switch ui-switch-md"><input name="enable_verification" type="checkbox" @if($setting->enable_verification == "yes") checked="checked" @endif /> <i></i></label>
                                        </span>
                                    </div>
                                    <div class="d-flex align-items-center px-4 py-3 b-t">
                                        <button type="submit" class="btn btn-primary mt-2">Update Preference</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection