@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Users KYC</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="toolbar">
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                    </div>
                                    <form class="flex" action="">
                                        <div class="input-group">
                                            <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="{{ $search }}" />
                                            <span class="input-group-append">
                                                <button class="btn btn-white no-border btn-sm" type="submit">
                                                    <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                </button>
                                            </span>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Email</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Status</th>
                                                <th style="width: 50px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            @if($users)
                                                @foreach($users as $user)
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted">{{ $user->id }}</small></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted">{{ $user->name }}</span></td>
                                                    <td class="no-wrap"><div class="item-date text-muted text-sm">{{ $user->email }}</div></td>
                                                    <td><span class="item-amount text-muted text-sm">{{ $user->account_verify }}</span></td>
                                                    <td>
                                                        <div class="item-action dropdown">
                                                            <a href="#" data-toggle="dropdown" class="text-muted"><i data-feather="more-vertical"></i></a>
                                                            <div class="dropdown-menu dropdown-menu-right bg-black" role="menu">
                                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#idModal-{{ $user->id }}">View ID</a>
                                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#passportModal-{{ $user->id }}">View Passport</a>
                                                                <a class="dropdown-item" href="{{ route('admin.user_kyc_accept', $user->id) }}" onclick="return confirm('are you sure you want to accept this kyc?')">Accept</a>
                                                                <a class="dropdown-item" href="{{ route('admin.user_kyc_reject', $user->id) }}" onclick="return confirm('are you sure you want to reject this kyc?')">Reject</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                <div id="idModal-{{ $user->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">{{ $user->name }} ID</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <img src="{{ image_url($user->id_card) }}" style="width: 100%;">
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="passportModal-{{ $user->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">{{ $user->name }} Passport</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <img src="{{ image_url($user->passport) }}" style="width: 100%;">
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                @if($users)
                                    {{ $users->withQueryString()->links() }}
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection