@extends('admin.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Manage Users</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ admin()->type }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('admin.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <a href="javascript:void(0)" class="btn btn-primary mb-4" data-toggle="modal" data-target="#addUserModal">Add User</a>
                            <a href="javascript:void(0)" class="btn btn-success mb-4" data-toggle="modal" data-target="#messageAllModal">Message all Users</a>
                            <a href="{{ route('admin.user_kyc') }}" class="btn btn-warning mb-4">KYC</a>
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="toolbar">
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                    </div>
                                    <form class="flex" action="">
                                        <div class="input-group">
                                            <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="{{ $search }}" />
                                            <span class="input-group-append">
                                                <button class="btn btn-white no-border btn-sm" type="submit">
                                                    <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                </button>
                                            </span>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Balance</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Client Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Email</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Phone</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Status</th>
                                                <th class="text-muted">Date</th>
                                                <th style="width: 50px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            @if($users)
                                                @foreach($users as $user)
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-{{ $user->status == 'blocked' ? 'danger' : 'mutted' }}">{{ $user->id }}</small></td>
                                                    <td><span class="item-amount text-sm text-{{ $user->status == 'blocked' ? 'danger' : 'mutted' }}">${{ number_format($user->account_bal, 2, '.', ',') }}</span></td>
                                                    <td><span class="item-badge badge text-uppercase text-{{ $user->status == 'blocked' ? 'danger' : 'mutted' }}">{{ $user->name }}</span></td>
                                                    <td class="no-wrap"><div class="item-date text-{{ $user->status == 'blocked' ? 'danger' : 'mutted' }} text-sm">{{ $user->email }}</div></td>
                                                    <td><span class="item-amount text-{{ $user->status == 'blocked' ? 'danger' : 'mutted' }} text-sm">{{ $user->phone }}</span></td>
                                                    <td><span class="item-amount text-{{ $user->status == 'blocked' ? 'danger' : 'mutted' }} text-sm">{{ $user->status }}</span></td>
                                                    <td class="no-wrap"><span class="item-amount text-{{ $user->status == 'blocked' ? 'danger' : 'mutted' }} text-sm">{{ $user->entered_at ? \Carbon\Carbon::parse($user->entered_at)->format('d-m-Y H:ia') : '' }}</span></td>
                                                    <td>
                                                        <div class="item-action dropdown">
                                                            <a href="#" data-toggle="dropdown" class="text-muted"><i data-feather="more-vertical"></i></a>
                                                            <div class="dropdown-menu dropdown-menu-right bg-black" role="menu">
                                                                <a class="dropdown-item text-warning" href="{{ route('admin.user_plans', $user->id) }}">Investment plans</a>
                                                                <a class="dropdown-item text-info" href="{{ route('admin.user_wallet', $user->id) }}">See wallet</a>
                                                                @if(admin()->type == "Super Admin")
                                                                <a class="dropdown-item text-danger d-{{ $user->status != 'active' ? 'none' : NULL }}" href="{{ route('admin.user_block', $user->id) }}">Block</a>
                                                                <a class="dropdown-item text-success d-{{ $user->status == 'active' ? 'none' : NULL }}" href="{{ route('admin.user_activate', $user->id) }}">Activate</a>
                                                                @endif
                                                                <a class="dropdown-item text-success d-{{ $user->trade_mode == 'on' ? 'none' : NULL }}" href="{{ route('admin.user_turn_on_trade', $user->id) }}">Turn on trade</a>
                                                                <a class="dropdown-item text-danger d-{{ $user->trade_mode != 'on' ? 'none' : NULL }}" href="{{ route('admin.user_turn_off_trade', $user->id) }}">Turn off trade</a>
                                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#cdModal-{{ $user->id }}">Credit / Debit</a>
                                                                @if(admin()->type == "Super Admin")
                                                                <a class="dropdown-item text-warning" href="javascript:void(0)" data-toggle="modal" data-target="#passwordModal-{{ $user->id }}">Reset password</a>
                                                                <a class="dropdown-item text-warning" href="{{ route('admin.user_clear_account', $user->id) }}" onclick="return confirm('are you sure you want to clear the account of this user to $0.00? this operation cannot be rolled back')">Clear account</a>
                                                                @endif
                                                                <a class="dropdown-item text-primary" href="javascript:void(0)" data-toggle="modal" data-target="#historyModal-{{ $user->id }}">Add trading history</a>
                                                                @if(admin()->type == "Super Admin")
                                                                <a class="dropdown-item text-danger" href="{{ route('admin.user_delete', $user->id) }}" onclick="return confirm('are you sure you want to delete this user? this operation cannot be rolled back')">Delete</a>
                                                                <a class="dropdown-item text-primary" href="javascript:void(0)" data-toggle="modal" data-target="#editModal-{{ $user->id }}">Edit</a>
                                                                @endif
                                                                <a class="dropdown-item text-info" href="javascript:void(0)" data-toggle="modal" data-target="#messageModal-{{ $user->id }}">Send message</a>
                                                                <a class="dropdown-item text-success" target="_blank" href="{{ route('admin.user_get_access', $user->id) }}" onclick="return confirm('are you sure you want to login to this user dashboard?')">Get access</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                <div id="cdModal-{{ $user->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Credit / Debit User</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.user_credit_debit') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    <div class="form-group">
                                        <label>Amount</label>
                                        <input class="form-control" type="number" name="amount" placeholder="Enter amount">
                                    </div>
                                    <div class="form-group">
                                        <label>Select where to Credit/Debit</label>
                                        <select class="form-control" type="text" name="column">
                                            <option value="Bonus">Bonus</option>
                                            <option value="Profit">Profit</option>
                                            <option value="Ref_Bonus">Ref_Bonus</option>
                                            <option value="Deposit">Deposit</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Select credit to add, debit to subtract</label>
                                        <select class="form-control" type="text" name="type">
                                            <option value="Credit">Credit</option>
                                            <option value="Debit">Debit</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="passwordModal-{{ $user->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Reset User Password</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.user_reset_password') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    <div class="form-group">
                                        <label>Are you sure you want to reset password for {{ $user->name }} to <a href="#">user01236</a></label>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Reset Password</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="historyModal-{{ $user->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Add Trading History to User</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.user_add_trading_history') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    <div class="form-group">
                                        <label>Select plan</label>
                                        <select class="form-control" type="text" name="plan">
                                            @if($plans)
                                                @foreach($plans->sortBy("price") as $plan)
                                                    <option value="{{ $plan->id }}">{{ $plan->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Amount</label>
                                        <input class="form-control" type="number" name="amount" placeholder="Enter amount">
                                    </div>
                                    <div class="form-group">
                                        <label>Select type</label>
                                        <select class="form-control" type="text" name="type">
                                            <option value="Bonus">Bonus</option>
                                            <option value="ROI">ROI</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="editModal-{{ $user->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Edit User</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.user_edit') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    <div class="form-group">
                                        <label>Name</label>
                                        <input class="form-control" type="text" name="name" placeholder="Enter name" value="{{ $user->name }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input class="form-control" type="text" name="email" placeholder="Enter email" value="{{ $user->email }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Phone Number</label>
                                        <input class="form-control" type="text" name="phone" placeholder="Enter phone" value="{{ $user->phone }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Referral Link</label>
                                        <input class="form-control" type="text" name="ref_link" placeholder="Enter referral link" value="{{ $user->ref_link }}">
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="messageModal-{{ $user->id }}" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Send Mail to {{ $user->name }}</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="{{ route('admin.user_mail') }}">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    <div class="form-group">
                                        <label>Subject</label>
                                        <input class="form-control" type="text" name="subject" placeholder="Type subject here"></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Message</label>
                                        <textarea class="form-control" type="text" name="body" placeholder="Type your message here"></textarea>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                @if($users)
                                    {{ $users->withQueryString()->links() }}
                                @endif
                            </div>
                            <!-- .modal -->
                            <div id="modal" class="modal fade" data-backdrop="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header"><h5 class="modal-title">New invoice</h5></div>
                                        <div class="modal-body p-4">
                                            <form>
                                                <div class="form-row">
                                                    <div class="form-group col-md-6"><label class="text-muted">First Name</label><input type="text" class="form-control" placeholder="First name" /></div>
                                                    <div class="form-group col-md-6"><label class="text-muted">Last Name</label><input type="text" class="form-control" placeholder="Last name" /></div>
                                                </div>
                                                <div class="form-row">
                                                    <div class="form-group col-md-6"><label class="text-muted">Email</label><input type="email" class="form-control" placeholder="Email" /></div>
                                                    <div class="form-group col-md-6">
                                                        <label class="text-muted">Password <small>(Register account)</small></label><input type="password" class="form-control" placeholder="Password" />
                                                    </div>
                                                </div>
                                                <div class="form-group"><label class="text-muted">Address</label><input type="text" class="form-control" placeholder="1234 Main St" /></div>
                                                <div class="form-row">
                                                    <div class="form-group col-md-6"><label class="text-muted">City</label><input type="text" class="form-control" /></div>
                                                    <div class="form-group col-md-4">
                                                        <label for="inputState" class="text-muted d-block">State</label>
                                                        <select class="custom-select">
                                                            <option selected="selected">Choose...</option>
                                                            <option>...</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-2"><label class="text-muted">Zip</label><input type="text" class="form-control" /></div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                            </div>
                            <div id="messageAllModal" class="modal fade" data-backdrop="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <div class="modal-title text-md">Send Mail to all Users</div>
                                            <button class="close" data-dismiss="modal">&times;</button>
                                        </div>
                                        <div class="modal-body">
                                            <form method="post" action="{{ route('admin.user_mail') }}">
                                                @csrf
                                                <div class="form-group">
                                                    <label>Subject</label>
                                                    <input class="form-control" type="text" name="subject" placeholder="Type subject here"></textarea>
                                                </div>
                                                <div class="form-group">
                                                    <label>Message</label>
                                                    <textarea class="form-control" type="text" name="body" placeholder="Type your message here"></textarea>
                                                </div>
                                                <div class="form-group">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                            </div>
                            <!-- / .modal -->
                            <div id="addUserModal" class="modal fade" data-backdrop="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <div class="modal-title text-md">Add New User</div>
                                            <button class="close" data-dismiss="modal">&times;</button>
                                        </div>
                                        <div class="modal-body">
                                            <form method="post" action="{{ route('admin.user_add') }}">
                                                @csrf
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="name" placeholder="Enter name">
                                                </div>
                                                <div class="form-group">
                                                    <label>Email</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="email" placeholder="Enter email">
                                                </div>
                                                <div class="form-group">
                                                    <label>Phone Number</label>
                                                    <input autocomplete="off" class="form-control" type="text" name="phone" placeholder="Enter phone">
                                                </div>
                                                <div class="form-group">
                                                    <label>Password</label>
                                                    <input autocomplete="new-password" class="form-control" type="password" name="password" placeholder="Enter password">
                                                </div>
                                                <div class="form-group">
                                                    <label>Confirm Password</label>
                                                    <input autocomplete="new-password" class="form-control" type="password" name="confirm_password" placeholder="Confirm password">
                                                </div>
                                                <div class="form-group">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection