@extends('user.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Available Plan</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ user()->name }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('user.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="row">
                                @if($plans)
                                    @foreach($plans->sortBy("price") as $plan)
                                        <div class="col-sm-6">
                                            <div class="card" style="box-shadow: 4px #000000;">
                                                <div class="card-body">
                                                    <h5 class="card-title text-center text-success">{{ $plan->name }}</h5>
                                                    <h2 class="card-title text-center">${{ number_format($plan->price, 2, '.', ',') }}</h2>
                                                </div>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Possible Deposit:</span> <span>${{ number_format($plan->min_price, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Possible Deposit:</span> <span>${{ number_format($plan->max_price, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Return:</span> <span>${{ number_format($plan->minr, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Return:</span> <span>${{ number_format($plan->maxr, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Duration:</span> <span>{{ $plan->expiration }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Increment Interval:</span> <span>{{ $plan->increment_interval }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Percentage Increase:</span> <span>{{ $plan->increment_amount }}%</span></li>
                                                </ul>
                                                <div class="card-body text-center">
                                                    <form method="post" action="{{ route('user.investment_plan_join') }}">
                                                        @csrf
                                                        <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                                                        <p class="text-center">Amount to invest : default(${{ number_format($plan->min_price, 2, '.', ',') }})</p>
                                                        <input type="number" name="amount" class="form-control" placeholder="${{ number_format($plan->min_price, 2, '.', ',') }}" value="{{ $plan->min_price }}">
                                                        <button onclick="return confirm('are you sure you want to join this plan?')" class="btn btn-primary mt-1 btn-block">Join plan</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

@endsection