@extends('user.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">My Packages</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ user()->name }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('user.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="row">
                                @if($plans)
                                    @foreach($plans->sortBy("price") as $plan)
                                        <div class="col-sm-6">
                                            <div class="card" style="box-shadow: 4px #000000;">
                                                <div class="card-body">
                                                    <h5 class="card-title text-center text-success">{{ $plan->name }}</h5>
                                                </div>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between"><span>Amount Deposit:</span> <span>${{ number_format($plan->amount, 2, '.', ',') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Last RIO Date:</span> <span>{{ \Carbon\Carbon::parse($plan->last_growth)->format('Y-m-d H:i') }}</span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Expiration Date:</span> <span>{{ \Carbon\Carbon::parse($plan->expire_date)->format('Y-m-d H:i') }}</span></li>
                                                </ul>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

@endsection