@extends('user.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Notification</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ user()->name }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('user.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                                <div class=" bg-body" id="chat-nav">
                                    <div class="navbar">
                                        <div class="input-group flex bg-light rounded">
                                            <input type="text" class="form-control no-bg no-border no-shadow search" placeholder="Search" required="" />
                                            <span class="input-group-append">
                                                <button class="btn no-bg no-shadow" type="button"><i data-feather="search" class="text-fade"></i></button>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="scrollable hover">
                                        <div class="list list-row">
                                            @if($notifications)
                                                @foreach($notifications as $notification)
                                                    <div class="list-item" data-id="{{ $loop->index + 1 }}">
                                                        <div><span class="avatar-status {{ $new ? 'on' : 'off' }}"></span></div>
                                                        <div class="flex">
                                                            <a href="javascript:void(0)" class="item-author text-sm text-color">{{ to_time($notification->created_at) }}</a>
                                                            <div class="text-muted text-xlg">{{ $notification->message }}</div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                        @if($notifications)
                                            {{ $notifications->withQueryString()->links() }}
                                        @endif
                                        <div class="no-result @if(count($notifications) > 0) hide @endif"><div class="p-4 text-center">No Results</div></div>
                                    </div>
                                </div>
                            </div>
                </div>
                <!-- ############ Main END-->
@endsection