@extends('user.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Profile</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ user()->name }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('user.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="card p-4">
                                <form method="post" action="{{ route('user.profile_update') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row p-2">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Name.</label>
                                                <input type="text" name="name" class="form-control" placeholder="Enter your name" value="{{ user()->name }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Date of Birth.</label>
                                                <input type="date" name="dob" class="form-control" placeholder="Enter your date of birth" value="{{ user()->dob ? \Carbon\Carbon::parse(user()->dob)->format('Y-m-d') : NULL }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Phon Number.</label>
                                                <input type="text" name="phone" class="form-control" placeholder="Enter your phone number" value="{{ user()->phone }}">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Address.</label>
                                                <textarea type="text" name="address" class="form-control" placeholder="Enter your address">{{ user()->address }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button class="btn btn-primary">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection