@extends('user.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Referrals</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ user()->name }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('user.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="card text-center p-4">
                                <p>You can refer users by sharing your referral link:</p>
                                <p class="text-success">{{ route('user.register', user()->id) }} </p>
                            </div>
                            <div class="card p-4">
                                <div id="invoice-list" data-plugin="invoice">
                                    <div class="toolbar">
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                        </div>
                                        <form class="flex" action="">
                                            <div class="input-group">
                                                <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="{{ $search }}" />
                                                <span class="input-group-append">
                                                    <button class="btn btn-white no-border btn-sm" type="submit">
                                                        <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                    </button>
                                                </span>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-theme table-row v-middle">
                                            <thead>
                                                <tr>
                                                    <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                    <th class="text-muted sort sortable" data-sort="item-badge">Name</th>
                                                    <th class="text-muted sort sortable" data-sort="item-badge">Status</th>
                                                    <th class="text-muted sort sortable" data-sort="item-badge">Date</th>
                                                </tr>
                                            </thead>
                                            <tbody class="list">
                                                @if($referrals)
                                                    @foreach($referrals as $referral)
                                                    <tr class="v-middle" data-id="2">
                                                        <td style="min-width: 30px; text-align: center;"><small class="text-muted">{{ $referral->id }}</small></td>
                                                        <td class="no-wrap"><span class="item-amount text-muted text-sm">{{ $referral->name }}</span></td>
                                                        <td><span class="item-amount text-muted text-sm">{{ $referral->status }}</span></td>
                                                        <td class="no-wrap"><span class="item-amount text-muted text-sm">{{ $referral->created_at ? \Carbon\Carbon::parse($referral->created_at)->format('d-m-Y H:ia') : '' }}</span></td>
                                                    </tr>
                                                    @endforeach
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                    @if($referrals)
                                        {{ $referrals->withQueryString()->links() }}
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection