<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>{{ app_name('separated') }}</title>
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <!-- style -->
        <link rel="icon" type="img/png" href="https://crestsvalue.com/wp-content/uploads/2021/04/rex-png-1-6.png">
        <link rel="stylesheet" href="/assets/css/site.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    </head>
    <body class="layout-row bg-dark">
        <div class="flex">
            <div class="w-xl w-auto-sm mx-auto py-5">
                @include('user.alert')
                <div class="p-4 d-flex flex-column h-100">
                  <!-- brand -->
                    <a href="https://fathomgainai.com/" class=" align-self-center">
                         <svg viewBox="81.0246 81.0246 548.8761 548.8761" width="41" height="41" xmlns="http://www.w3.org/2000/svg">
                                                                    <g transform="matrix(8.102457046508789, 0, 0, 8.102457046508789, 81.02456785775075, 81.02456785775077)">
                                                                        <g id="SvgjsG7655" featurekey="rDwwlG-0" transform="matrix(0.846774193548387,0,0,0.846774193548387,-8.46774193548387,-8.46774193548387)" fill="#fff">
                                                                            <path xmlns="http://www.w3.org/2000/svg" d="M35,65.833c0-8.587,3.535-16.36,9.219-21.956c-3.063-1.406-6.458-2.21-10.052-2.21C20.82,41.667,10,52.487,10,65.833  C10,79.18,20.82,90,34.167,90c3.594,0,6.988-0.804,10.052-2.21C38.535,82.194,35,74.421,35,65.833z"></path>
                                                                            <path xmlns="http://www.w3.org/2000/svg" d="M65.833,65c-8.587,0-16.36-3.535-21.956-9.222c-1.406,3.066-2.21,6.461-2.21,10.055C41.667,79.18,52.487,90,65.833,90  C79.18,90,90,79.18,90,65.833c0-3.594-0.804-6.988-2.21-10.055C82.194,61.465,74.421,65,65.833,65z"></path>
                                                                            <path xmlns="http://www.w3.org/2000/svg" d="M65.833,10c-3.594,0-6.988,0.804-10.055,2.21C61.465,17.806,65,25.579,65,34.167c0,8.587-3.535,16.36-9.222,21.956  c3.066,1.406,6.461,2.21,10.055,2.21C79.18,58.333,90,47.513,90,34.167C90,20.82,79.18,10,65.833,10z"></path>
                                                                            <path xmlns="http://www.w3.org/2000/svg" d="M34.167,35c8.587,0,16.36,3.535,21.956,9.219c1.406-3.063,2.21-6.458,2.21-10.052C58.333,20.82,47.513,10,34.167,10  C20.82,10,10,20.82,10,34.167c0,3.594,0.804,6.988,2.21,10.052C17.806,38.535,25.579,35,34.167,35z"></path>
                                                                        </g>
                                                                        <g id="SvgjsG7656" featurekey="4AZ1rv-0" transform="matrix(3.69061297442637,0,0,3.69061297442637,82.98076762185154,-14.988979054307197)" fill="#fff"></g>
                                                                    </g>
                                                                </svg>
                                                                <b style="color:white; font-size:24px;">Vanturaholding</b>
                    </a>
                    <!-- / brand -->
                </div>
                <div class="card">
                    <div id="content-body">
                        <div class="p-3 p-md-5">
                            <h5>Welcome</h5>
                            <p><small class="text-muted">creat account with us</small></p>
                            <form method="post" role="form" action="{{ route('user.register_post') }}">
                                @csrf
                                <input type="hidden" name="ref_by" value="{{ $ref_by }}">
                                <div class="form-group">
                                    <label>Full Name</label>
                                    <input autocomplete="off" type="text" name="name" class="form-control" placeholder="Enter name" />
                                </div>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input autocomplete="off" type="email" name="email" class="form-control" placeholder="Enter email" />
                                </div>
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input autocomplete="off" type="number" name="phone" class="form-control" placeholder="Enter phone" />
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Password</label>
                                            <input autocomplete="new-password" type="password" name="password" class="form-control" placeholder="Password" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Confirm Pass.</label>
                                            <input autocomplete="new-password" type="password" name="confirm_password" class="form-control" placeholder="Confirm Password" />
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Country</label>
                                    <select id="country" autocomplete="off" type="text" name="country" class="form-control" placeholder="Enter phone" >
                                    </select>
                                </div>
                                
                                <button type="submit" class="btn btn-primary mb-4">Sign up</button>
                                <div>Already registered an account? <a href="{{ route('user.login') }}" class="text-primary">Login</a></div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center text-muted">&copy; Copyright. {{ app_name('separated') }}</div>
            </div>
        </div>
        <script src="/assets/js/site.min.js"></script>
        <script type="text/javascript">
            $.getJSON('/json/country.json', function (data) {
                $('#country').append('<option value="">Choose Country</option>');
                $.each(data, function (key, entry) {
                    $('#country').append('<option value="'+ entry.name +'">'+ entry.name +'</option>');
                })
            });
        </script>
    </body>
</html>
