@extends('user.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Verify Account</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ user()->name }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('user.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="card p-4">
                                <form method="post" action="{{ route('user.verify_account_submit') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row p-2">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>KYC verification - Upload documents below to get verified.</h5>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Valid identity card. (e.g. Drivers licence, international passport or any government approved document).</label>
                                                <input type="file" name="id_card" class="form-control" placeholder="Enter your name" accept=".png,.jpg,.jpeg">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Passport photogragh</label>
                                                <input type="file" name="passport" class="form-control" placeholder="Enter your date of birth" accept=".png,.jpg,.jpeg">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection