@extends('user.app')

@section('content')
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Withdrawal Details</h2>
                                <small class="text-muted">Welcome aboard, <strong>{{ user()->name }}</strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        @include('user.alert')
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="card p-4">
                                <form method="post" action="{{ route('user.withdrawal_details_update') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row p-2">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Bitcoin Address.</label>
                                                <input type="text" name="btc_address" class="form-control" placeholder="Enter your bitcoin address" value="{{ user()->btc_address }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Etherium Address.</label>
                                                <input type="text" name="eth_address" class="form-control" placeholder="Enter your etherium address" value="{{ user()->eth_address }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Litecoin Address.</label>
                                                <input type="text" name="ltc_address" class="form-control" placeholder="Enter your litecoin address" value="{{ user()->ltc_address }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Dodgecoin Address.</label>
                                                <input type="text" name="dodge_address" class="form-control" placeholder="Enter your dodgecoin address" value="{{ user()->dodge_address }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>BNB Address.</label>
                                                <input type="text" name="bnb_address" class="form-control" placeholder="Enter your bnb address" value="{{ user()->bnb_address }}">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button class="btn btn-primary">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
@endsection