<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('admin')->group(function () {
	Route::get('/login', 'App\Http\Controllers\AdminController@login')->name('admin.login');
	Route::post('/login', 'App\Http\Controllers\AdminController@login_post')->name('admin.login_post');
	Route::get('/logout', 'App\Http\Controllers\AdminController@logout')->name('admin.logout');

	Route::get('/', 'App\Http\Controllers\AdminController@dashboard')->name('admin.index')->middleware(['admin']);
	Route::get('/dashboard', 'App\Http\Controllers\AdminController@dashboard')->name('admin.dashboard')->middleware(['admin']);

	Route::post('/account-update', 'App\Http\Controllers\AdminController@account_update')->name('admin.account_update')->middleware(['admin']);
	Route::post('/change-password', 'App\Http\Controllers\AdminController@change_password')->name('admin.change_password')->middleware(['admin']);

	Route::get('/plan', 'App\Http\Controllers\AdminController@plan')->name('admin.plan')->middleware(['admin']);
	Route::post('/plan-add', 'App\Http\Controllers\AdminController@plan_add')->name('admin.plan_add')->middleware(['admin']);
	Route::post('/plan-edit', 'App\Http\Controllers\AdminController@plan_edit')->name('admin.plan_edit')->middleware(['admin']);
	Route::get('/plan-delete/{id}', 'App\Http\Controllers\AdminController@plan_delete')->name('admin.plan_delete')->middleware(['admin']);

	Route::get('/users', 'App\Http\Controllers\AdminController@users')->name('admin.users')->middleware(['admin']);
	Route::post('/user-add', 'App\Http\Controllers\AdminController@user_add')->name('admin.user_add')->middleware(['admin']);
	Route::get('/user-plans/{id}', 'App\Http\Controllers\AdminController@user_plans')->name('admin.user_plans')->middleware(['admin']);
	Route::get('/user-wallet/{id}', 'App\Http\Controllers\AdminController@user_wallet')->name('admin.user_wallet')->middleware(['admin']);
	Route::get('/user-block/{id}', 'App\Http\Controllers\AdminController@user_block')->name('admin.user_block')->middleware(['admin', 'super']);
	Route::get('/user-activate/{id}', 'App\Http\Controllers\AdminController@user_activate')->name('admin.user_activate')->middleware(['admin', 'super']);
	Route::get('/user-turn-off-trade/{id}', 'App\Http\Controllers\AdminController@user_turn_off_trade')->name('admin.user_turn_off_trade')->middleware(['admin']);
	Route::get('/user-turn-on-trade/{id}', 'App\Http\Controllers\AdminController@user_turn_on_trade')->name('admin.user_turn_on_trade')->middleware(['admin']);
	Route::post('/user-credit-debit', 'App\Http\Controllers\AdminController@user_credit_debit')->name('admin.user_credit_debit')->middleware(['admin']);
	Route::post('/user-reset-password', 'App\Http\Controllers\AdminController@user_reset_password')->name('admin.user_reset_password')->middleware(['admin', 'super']);
	Route::get('/user-clear-account/{id}', 'App\Http\Controllers\AdminController@user_clear_account')->name('admin.user_clear_account')->middleware(['admin', 'super']);
	Route::post('/user-add-trading-history', 'App\Http\Controllers\AdminController@user_add_trading_history')->name('admin.user_add_trading_history')->middleware(['admin']);
	Route::get('/user-delete/{id}', 'App\Http\Controllers\AdminController@user_delete')->name('admin.user_delete')->middleware(['admin', 'super']);
	Route::post('/user-edit', 'App\Http\Controllers\AdminController@user_edit')->name('admin.user_edit')->middleware(['admin', 'super']);
	Route::post('/user-mail', 'App\Http\Controllers\AdminController@user_mail')->name('admin.user_mail')->middleware(['admin']);
	Route::get('/user-kyc', 'App\Http\Controllers\AdminController@user_kyc')->name('admin.user_kyc')->middleware(['admin']);
	Route::get('/user-kyc-accept/{id}', 'App\Http\Controllers\AdminController@user_kyc_accept')->name('admin.user_kyc_accept')->middleware(['admin']);
	Route::get('/user-kyc-reject/{id}', 'App\Http\Controllers\AdminController@user_kyc_reject')->name('admin.user_kyc_reject')->middleware(['admin']);
	Route::get('/user-get-access/{id}', 'App\Http\Controllers\AdminController@user_get_access')->name('admin.user_get_access')->middleware(['admin']);

	Route::get('/deposits', 'App\Http\Controllers\AdminController@deposits')->name('admin.deposits')->middleware(['admin']);
	Route::get('/deposit-delete/{id}', 'App\Http\Controllers\AdminController@deposit_delete')->name('admin.deposit_delete')->middleware(['admin']);
	Route::get('/deposit-process/{id}', 'App\Http\Controllers\AdminController@deposit_process')->name('admin.deposit_process')->middleware(['admin']);

	Route::get('/withdrawals', 'App\Http\Controllers\AdminController@withdrawals')->name('admin.withdrawals')->middleware(['admin']);
	Route::get('/withdrawal-reject/{id}', 'App\Http\Controllers\AdminController@withdrawal_reject')->name('admin.withdrawal_reject')->middleware(['admin']);
	Route::get('/withdrawal-process/{id}', 'App\Http\Controllers\AdminController@withdrawal_process')->name('admin.withdrawal_process')->middleware(['admin']);

	Route::get('/agents', 'App\Http\Controllers\AdminController@agents')->name('admin.agents')->middleware(['admin']);
	Route::post('/agent-add', 'App\Http\Controllers\AdminController@agent_add')->name('admin.agent_add')->middleware(['admin']);
	Route::get('/agent-clients/{id}', 'App\Http\Controllers\AdminController@agent_clients')->name('admin.agent_clients')->middleware(['admin']);
	Route::get('/agent-delete/{id}', 'App\Http\Controllers\AdminController@agent_delete')->name('admin.agent_delete')->middleware(['admin']);
	Route::get('/agents', 'App\Http\Controllers\AdminController@agents')->name('admin.agents')->middleware(['admin']);

	Route::get('/administrators', 'App\Http\Controllers\AdminController@administrators')->name('admin.administrators')->middleware(['admin', 'super']);
	Route::post('/administrator-add', 'App\Http\Controllers\AdminController@administrator_add')->name('admin.administrator_add')->middleware(['admin', 'super']);
	Route::get('/administrator-block/{id}', 'App\Http\Controllers\AdminController@administrator_block')->name('admin.administrator_block')->middleware(['admin', 'super']);
	Route::get('/administrator-activate/{id}', 'App\Http\Controllers\AdminController@administrator_activate')->name('admin.administrator_activate')->middleware(['admin', 'super']);
	Route::post('/administrator-reset-password', 'App\Http\Controllers\AdminController@administrator_reset_password')->name('admin.administrator_reset_password')->middleware(['admin', 'super']);
	Route::get('/administrator-delete/{id}', 'App\Http\Controllers\AdminController@administrator_delete')->name('admin.administrator_delete')->middleware(['admin', 'super']);
	Route::post('/administrator-edit', 'App\Http\Controllers\AdminController@administrator_edit')->name('admin.administrator_edit')->middleware(['admin', 'super']);
	Route::post('/administrator-mail', 'App\Http\Controllers\AdminController@administrator_mail')->name('admin.administrator_mail')->middleware(['admin', 'super']);

	Route::get('/faqs', 'App\Http\Controllers\AdminController@faqs')->name('admin.faqs')->middleware(['admin']);
	Route::post('/faq-add', 'App\Http\Controllers\AdminController@faq_add')->name('admin.faq_add')->middleware(['admin']);
	Route::get('/faq-delete/{id}', 'App\Http\Controllers\AdminController@faq_delete')->name('admin.faq_delete')->middleware(['admin']);
	Route::post('/faq-edit', 'App\Http\Controllers\AdminController@faq_edit')->name('admin.faq_edit')->middleware(['admin']);

	Route::get('/testimonials', 'App\Http\Controllers\AdminController@testimonials')->name('admin.testimonials')->middleware(['admin']);
	Route::post('/testimonial-add', 'App\Http\Controllers\AdminController@testimonial_add')->name('admin.testimonial_add')->middleware(['admin']);
	Route::get('/testimonial-delete/{id}', 'App\Http\Controllers\AdminController@testimonial_delete')->name('admin.testimonial_delete')->middleware(['admin']);
	Route::post('/testimonial-edit', 'App\Http\Controllers\AdminController@testimonial_edit')->name('admin.testimonial_edit')->middleware(['admin']);

	Route::get('/contents', 'App\Http\Controllers\AdminController@contents')->name('admin.contents')->middleware(['admin']);
	Route::post('/content-add', 'App\Http\Controllers\AdminController@content_add')->name('admin.content_add')->middleware(['admin']);
	Route::get('/content-delete/{id}', 'App\Http\Controllers\AdminController@content_delete')->name('admin.content_delete')->middleware(['admin']);
	Route::post('/content-edit', 'App\Http\Controllers\AdminController@content_edit')->name('admin.content_edit')->middleware(['admin']);

	Route::get('/images', 'App\Http\Controllers\AdminController@images')->name('admin.images')->middleware(['admin']);
	Route::post('/image-add', 'App\Http\Controllers\AdminController@image_add')->name('admin.image_add')->middleware(['admin']);
	Route::get('/image-delete/{id}', 'App\Http\Controllers\AdminController@image_delete')->name('admin.image_delete')->middleware(['admin']);
	Route::post('/image-edit', 'App\Http\Controllers\AdminController@image_edit')->name('admin.image_edit')->middleware(['admin']);

	Route::get('/settings', 'App\Http\Controllers\AdminController@settings')->name('admin.settings')->middleware(['admin', 'super']);
	Route::post('/setting-edit', 'App\Http\Controllers\AdminController@setting_edit')->name('admin.setting_edit')->middleware(['admin', 'super']);
});

Route::prefix('user')->group(function () {
	Route::get('/register/{ref_by?}', 'App\Http\Controllers\UserController@register')->name('user.register');
	Route::post('/register', 'App\Http\Controllers\UserController@register_post')->name('user.register_post');
	Route::get('/login', 'App\Http\Controllers\UserController@login')->name('user.login');
	Route::post('/login', 'App\Http\Controllers\UserController@login_post')->name('user.login_post');
	Route::get('/forgot', 'App\Http\Controllers\UserController@forgot')->name('user.forgot');
	Route::post('/forgot', 'App\Http\Controllers\UserController@forgot_post')->name('user.forgot_post');
	Route::get('/reset-password/{token}', 'App\Http\Controllers\UserController@reset_password')->name('user.reset_password');
	Route::post('/reset-password', 'App\Http\Controllers\UserController@reset_password_post')->name('user.reset_password_post');
	Route::get('/logout', 'App\Http\Controllers\UserController@logout')->name('user.logout');
	Route::get('/verify-2fa', 'App\Http\Controllers\UserController@verify_2fa')->name('user.verify_2fa');
	Route::post('/verify-2fa', 'App\Http\Controllers\UserController@verify_2fa_post')->name('user.verify_2fa_post');
	Route::get('/verify/{token}', 'App\Http\Controllers\UserController@verify')->name('user.verify');

	Route::get('/', 'App\Http\Controllers\UserController@dashboard')->name('user.index')->middleware(['auth']);
	Route::get('/dashboard', 'App\Http\Controllers\UserController@dashboard')->name('user.dashboard')->middleware(['auth']);

	Route::get('/investment-plans', 'App\Http\Controllers\UserController@investment_plans')->name('user.investment_plans')->middleware(['auth']);
	Route::post('/investment-plan-join', 'App\Http\Controllers\UserController@investment_plan_join')->name('user.investment_plan_join')->middleware(['auth']);
	Route::get('/my-packages', 'App\Http\Controllers\UserController@my_packages')->name('user.my_packages')->middleware(['auth']);

	Route::get('/deposit', 'App\Http\Controllers\UserController@deposit')->name('user.deposit')->middleware(['auth']);
	Route::get('/payment', 'App\Http\Controllers\UserController@payment')->name('user.payment')->middleware(['auth']);
	Route::post('/payment-submit', 'App\Http\Controllers\UserController@payment_submit')->name('user.payment_submit')->middleware(['auth']);

	Route::get('/withdrawal', 'App\Http\Controllers\UserController@withdrawal')->name('user.withdrawal')->middleware(['auth', 'kyc']);
	Route::post('/withdrawal-submit', 'App\Http\Controllers\UserController@withdrawal_submit')->name('user.withdrawal_submit')->middleware(['auth', 'kyc']);
	Route::get('/withdrawal-details', 'App\Http\Controllers\UserController@withdrawal_details')->name('user.withdrawal_details')->middleware(['auth', 'kyc']);
	Route::post('/withdrawal-details-update', 'App\Http\Controllers\UserController@withdrawal_details_update')->name('user.withdrawal_details_update')->middleware(['auth', 'kyc']);

	Route::get('/transfer', 'App\Http\Controllers\UserController@transfer')->name('user.transfer')->middleware(['auth']);
	Route::post('/transfer', 'App\Http\Controllers\UserController@transfer_post')->name('user.transfer_post')->middleware(['auth']);

	Route::get('/referral', 'App\Http\Controllers\UserController@referral')->name('user.referral')->middleware(['auth']);

	Route::get('/roi-history', 'App\Http\Controllers\UserController@roi_history')->name('user.roi_history')->middleware(['auth']);
	Route::get('/deposit-history', 'App\Http\Controllers\UserController@deposit_history')->name('user.deposit_history')->middleware(['auth']);
	Route::get('/withdrawal-history', 'App\Http\Controllers\UserController@withdrawal_history')->name('user.withdrawal_history')->middleware(['auth']);
	Route::get('/other-history', 'App\Http\Controllers\UserController@other_history')->name('user.other_history')->middleware(['auth']);

	Route::get('/profile', 'App\Http\Controllers\UserController@profile')->name('user.profile')->middleware(['auth']);
	Route::post('/profile-update', 'App\Http\Controllers\UserController@profile_update')->name('user.profile_update')->middleware(['auth']);
	Route::post('/change-password', 'App\Http\Controllers\UserController@change_password')->name('user.change_password')->middleware(['auth']);

	Route::get('/verify-account', 'App\Http\Controllers\UserController@verify_account')->name('user.verify_account')->middleware(['auth']);
	Route::post('/verify-account-submit', 'App\Http\Controllers\UserController@verify_account_submit')->name('user.verify_account_submit')->middleware(['auth']);

	Route::get('/notification/{new?}', 'App\Http\Controllers\UserController@notification')->name('user.notification')->middleware(['auth']);

	Route::get('/support', 'App\Http\Controllers\UserController@support')->name('user.support')->middleware(['auth']);
});

Route::prefix('api')->group(function () {
	Route::get('/faqs', 'App\Http\Controllers\ApiController@faqs')->name('api.faqs');
	Route::get('/testimonials', 'App\Http\Controllers\ApiController@testimonials')->name('api.testimonials');
});

//normal route
Route::get('/', 'App\Http\Controllers\HomeController@index')->name('index');
Route::get('/about', 'App\Http\Controllers\HomeController@about')->name('about');
Route::get('/investment-plan', 'App\Http\Controllers\HomeController@investment_plan')->name('investment_plan');
Route::get('/faq', 'App\Http\Controllers\HomeController@faq')->name('faq');
Route::get('/policy', 'App\Http\Controllers\HomeController@policy')->name('policy');
Route::get('/legal', 'App\Http\Controllers\HomeController@legal')->name('legal');