<?php $__env->startSection('content'); ?>
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight"><?php echo e($user->name); ?> clients</h2>
                                <small class="text-muted">Welcome aboard, <strong><?php echo e(admin()->type); ?></strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        <?php echo $__env->make('admin.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Client Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Clients Inv Plan</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Clients Status</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Earnings</th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            <?php if($clients): ?>
                                                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted"><?php echo e($client->id); ?></small></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted"><?php echo e($client->name); ?></span></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted"><?php echo e($client->plan); ?></span></td>
                                                    <td><div class="item-date text-muted text-sm"><?php echo e($client->status); ?></div></td>
                                                    <td><div class="item-date text-muted text-sm">$<?php echo e(number_format($client->amount, 2, '.', ',')); ?></div></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php if($clients): ?>
                                    <?php echo e($clients->withQueryString()->links()); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/obiajulu/Laravel/Personal Works/castledigital/resources/views/admin/agent_clients.blade.php ENDPATH**/ ?>