<?php $__env->startSection('content'); ?>
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Other history</h2>
                                <small class="text-muted">Welcome aboard, <strong><?php echo e(user()->name); ?></strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        <?php echo $__env->make('user.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="card p-4">
                                <div id="invoice-list" data-plugin="invoice">
                                    <div class="toolbar">
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                        </div>
                                        <form class="flex" action="">
                                            <div class="input-group">
                                                <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="<?php echo e($search); ?>" />
                                                <span class="input-group-append">
                                                    <button class="btn btn-white no-border btn-sm" type="submit">
                                                        <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                    </button>
                                                </span>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-theme table-row v-middle">
                                            <thead>
                                                <tr>
                                                    <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                    <!-- <th class="text-muted sort sortable" data-sort="item-badge">Plan</th> -->
                                                    <th class="text-muted sort sortable" data-sort="item-badge">Amount</th>
                                                    <th class="text-muted sort sortable" data-sort="item-badge">Type</th>
                                                    <th class="text-muted sort sortable" data-sort="item-badge">Date</th>
                                                </tr>
                                            </thead>
                                            <tbody class="list">
                                                <?php if($others): ?>
                                                    <?php $__currentLoopData = $others; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr class="v-middle" data-id="2">
                                                        <td style="min-width: 30px; text-align: center;"><small class="text-muted"><?php echo e($other->id); ?></small></td>
                                                        <!-- <td class="no-wrap"><span class="item-amount text-muted text-sm"><?php echo e($other->plan); ?></span></td> -->
                                                        <td><span class="item-amount text-muted text-sm">$<?php echo e(number_format($other->amount, 2, '.', ',')); ?></span></td>
                                                        <td><span class="item-amount text-muted text-sm"><?php echo e($other->type); ?></span></td>
                                                        <td class="no-wrap"><span class="item-amount text-muted text-sm"><?php echo e($other->created_at ? \Carbon\Carbon::parse($other->created_at)->format('d-m-Y H:ia') : ''); ?></span></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php if($others): ?>
                                        <?php echo e($others->withQueryString()->links()); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/obiajulu/Laravel/Personal Works/castledigital/resources/views/user/other_history.blade.php ENDPATH**/ ?>