<!DOCTYPE html>
<html lang="en" id="html">
    <head>
        <meta charset="utf-8" />
        <title><?php echo e(app_name('separated')); ?></title>
        <meta name="description" content="" />
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <!-- style -->
        <link rel="icon" type="img/png" href="/logo.png">
        <link rel="stylesheet" href="/assets/css/site.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    </head>
    <body class="layout-row">
        <!-- ############ Aside START-->
        <div id="aside" class="page-sidenav no-shrink bg-light nav-dropdown fade" aria-hidden="true">
            <div class="sidenav h-100 modal-dialog bg-light">
                <!-- sidenav top -->
                <div class="navbar">
                    <!-- brand -->
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="navbar-brand">
                        <img src="/logo.png" width="32" height="32">
                        <span class="hidden-folded d-inline l-s-n-1x"><?php echo e(app_name('separated')); ?></span>
                    </a>
                    <!-- / brand -->
                </div>
                <!-- Flex nav content -->
                <div class="flex scrollable hover">
                    <div class="nav-active-text-primary" data-nav>
                        <ul class="nav bg">
                            <li class="nav-header hidden-folded"><span class="text-muted">Navigation</span></li>
                            <li>
                                <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-<?php echo e(current_route() == 'admin.dashboard' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i class="fas fa-home"></i></span> <span class="nav-text">Dashboard</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.plan')); ?>" class="text-<?php echo e(current_route() == 'admin.plan' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i class="fas fa-cubes"></i></span> <span class="nav-text">Investment Plans</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.users')); ?>" class="text-<?php echo e(current_route() == 'admin.users' || current_route() == 'admin.user_wallet' || current_route() == 'admin.user_plans' || current_route() == 'admin.user_kyc' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i  class="fas fa-user-circle"></i></span> <span class="nav-text">Manage Users</span>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0)" class="text-<?php echo e(current_route() == 'admin.deposits' || current_route() == 'admin.withdrawals' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i class="fas fa-credit-card"></i></span> <span class="nav-text">Manage D/W</span> <span class="nav-caret"></span>
                                </a>
                                <ul class="nav-sub nav-mega">
                                    <li>
                                        <a href="<?php echo e(route('admin.deposits')); ?>" class="text-<?php echo e(current_route() == 'admin.deposits' ? 'primary' : NULL); ?>"><span class="nav-text">Manage Deposit</span></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.withdrawals')); ?>" class="text-<?php echo e(current_route() == 'admin.withdrawals' ? 'primary' : NULL); ?>"><span class="nav-text">Manage Withdrawal</span></a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.agents')); ?>" class="text-<?php echo e(current_route() == 'admin.agents' || current_route() == 'admin.agent_clients' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i class="fas fa-users"></i></span> <span class="nav-text">View Agents</span>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0)">
                                    <span class="nav-icon"><i class="fas fa-sync-alt"></i></span> <span class="nav-text">Manage Subscription</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.administrators')); ?>" class="text-<?php echo e(current_route() == 'admin.administrators' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i  class="fas fa-users"></i></span> <span class="nav-text">Administrators</span>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0)" class="text-<?php echo e(current_route() == 'admin.faqs' || current_route() == 'admin.testimonials' || current_route() == 'admin.contents' || current_route() == 'admin.images' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i class="fas fa-sitemap"></i></span> <span class="nav-text">Front-end Control</span><span class="nav-caret"></span>
                                </a>
                                <ul class="nav-sub nav-mega">
                                    <li>
                                        <a href="<?php echo e(route('admin.faqs')); ?>"  class="text-<?php echo e(current_route() == 'admin.faqs' ? 'primary' : NULL); ?>"><span class="nav-text">FAQs</span></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.testimonials')); ?>" class="text-<?php echo e(current_route() == 'admin.testimonials' ? 'primary' : NULL); ?>"><span class="nav-text">Testimonials</span></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.contents')); ?>" class="text-<?php echo e(current_route() == 'admin.contents' ? 'primary' : NULL); ?>"><span class="nav-text">Contents</span></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.images')); ?>" class="text-<?php echo e(current_route() == 'admin.images' ? 'primary' : NULL); ?>"><span class="nav-text">Images</span></a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.settings')); ?>" class="text-<?php echo e(current_route() == 'admin.settings' ? 'primary' : NULL); ?>">
                                    <span class="nav-icon"><i class="fas fa-cog"></i></span> <span class="nav-text">Settings</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!-- ############ Aside END-->
        <div id="main" class="layout-column flex">
            <!-- ############ Header START-->
            <div id="header" class="page-header">
                <div class="navbar navbar-expand-lg">
                    <!-- brand -->
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="navbar-brand d-lg-none">
                        <img src="/logo.png" width="32" height="32">
                        <span class="hidden-folded d-inline l-s-n-1x d-lg-none"><?php echo e(app_name('separate')); ?></span>
                    </a>
                    <!-- / brand --><!-- Navbar collapse -->
                    <div class="collapse navbar-collapse order-2 order-lg-1" id="navbarToggler">
                        <form class="input-group m-2 my-lg-0" action="<?php echo e(route('admin.users')); ?>">
                            <div class="input-group-prepend">
                                <button type="button" class="btn no-shadow no-bg px-0 text-inherit"><i data-feather="search"></i></button>
                            </div>
                            <input type="text" class="form-control no-border no-shadow no-bg typeahead" placeholder="Search users..." name="search" />
                        </form>
                    </div>
                    <ul class="nav navbar-menu order-1 order-lg-2">
                        <!-- Notification -->
                        <li class="nav-item mr-3">
                            <div class="setting mt-2">
                                <label class="radio radio-inline ui-check ui-check-md"><input type="radio" name="bg" value="" /> <i></i></label>
                                <label class="radio radio-inline ui-check ui-check-color ui-check-md"><input type="radio" name="bg" value="bg-dark" /> <i class="bg-dark"></i></label>
                            </div>
                        </li>
                        <!-- User dropdown menu -->
                        <li class="nav-item dropdown">
                            <a href="javascript:void(0)" data-toggle="dropdown" class="nav-link d-flex align-items-center px-2 text-color">
                                <span class="avatar w-24" style="margin: -2px;"><img src="../assets/img/a0.jpg" alt="..." /></span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right w mt-3 animate fadeIn">
                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#accountSettingsModal"><span>Account Settings</span> </a>
                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#changePasswordModal">Change Password</a>
                                <div class="dropdown-divider"></div>
                                <a onclick="return confirm('are you sure you want to logout of the system')" class="dropdown-item" href="<?php echo e(route('admin.logout')); ?>">Sign out</a>
                            </div>
                        </li>
                        <!-- Navarbar toggle btn -->
                        <li class="nav-item d-lg-none">
                            <a href="javascript:void(0)" class="nav-link px-2" data-toggle="collapse" data-toggle-class data-target="#navbarToggler"><i data-feather="search"></i></a>
                        </li>
                        <li class="nav-item d-lg-none">
                            <a class="nav-link px-1" data-toggle="modal" data-target="#aside"><i data-feather="menu"></i></a>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- ############ Footer END--><!-- ############ Content START-->
            <div id="content" class="flex">

                <?php echo $__env->yieldContent('content'); ?>

            </div>
            <!-- ############ Content END--><!-- ############ Footer START-->
            <div id="footer" class="page-footer hide">
                <div class="d-flex p-3">
                    <span class="text-sm text-muted flex">&copy; Copyright. <?php echo e(app_name('separated')); ?></span>
                    <div class="text-sm text-muted">Version 1.0.1</div>
                </div>
            </div>
            <!-- ############ Footer END-->
            <div id="accountSettingsModal" class="modal fade" data-backdrop="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <div class="modal-title text-md">Edit Account</div>
                            <button class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <div class="modal-body">
                            <form method="post" action="<?php echo e(route('admin.account_update')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label>Firs Name</label>
                                    <input class="form-control" type="text" name="firstName" placeholder="Enter first name" value="<?php echo e(admin()->firstName); ?>">
                                </div>
                                <div class="form-group">
                                    <label>Last Name</label>
                                    <input class="form-control" type="text" name="lastName" placeholder="Enter last name" value="<?php echo e(admin()->lastName); ?>">
                                </div>
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input class="form-control" type="text" name="phone" placeholder="Enter phone" value="<?php echo e(admin()->phone); ?>">
                                </div>
                                <div class="form-group">
                                    <label>Two Facto Authentication</label>
                                    <select class="form-control" type="text" name="enable_2fa" value="<?php echo e(admin()->enable_2fa); ?>">
                                        <option <?php if(admin()->enable_2fa == "enabled"): ?> selected <?php endif; ?> value="enabled">enabled</option>
                                        <option <?php if(admin()->enable_2fa == "disabled"): ?> selected <?php endif; ?> value="disabled">disabled</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
                    <!-- /.modal-content -->
            <div id="changePasswordModal" class="modal fade" data-backdrop="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <div class="modal-title text-md">Change Account Password</div>
                            <button class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <div class="modal-body">
                            <form method="post" action="<?php echo e(route('admin.change_password')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label>Old Password</label>
                                    <input class="form-control" type="password" name="old_password" placeholder="Enter old password">
                                </div>
                                <div class="form-group">
                                    <label>New Password</label>
                                    <input class="form-control" type="password" name="new_password" placeholder="Enter new password">
                                </div>
                                <div class="form-group">
                                    <label>Confirm New Password</label>
                                    <input class="form-control" type="password" name="confirm_new_password" placeholder="Confirm new password">
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
            </div>
        </div>
        <script src="/assets/js/site.min.js"></script>
        <script type="text/javascript">
            var dwt = JSON.parse("<?php echo e(dwt()); ?>")
        </script>
    </body>
    <!-- Mirrored from flatfull.com/themes/basik/html/dashboard.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 22 Oct 2021 13:01:11 GMT -->
</html>
<?php /**PATH /home/premjnqi/tradinginsight-fx.com/castledigital/resources/views/admin/app.blade.php ENDPATH**/ ?>