<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title><?php echo e(app_name('separated')); ?></title>
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <!-- style -->
        <link rel="icon" type="img/png" href="https://allegianceprime-fx.com/img/logo.png">
        <link rel="stylesheet" href="/assets/css/site.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    </head>
    <body class="layout-row bg-dark">
        <div class="flex">
            <div class="w-xl w-auto-sm mx-auto py-5">
                <?php echo $__env->make('user.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="p-4 d-flex flex-column h-100">
                    <!-- brand -->
                    <a href="https://allegianceprime-fx.com/" class=" align-self-center">
                        <img src="https://allegianceprime-fx.com/img/logo.png" width="200" height="150">
                            <!-- <span class="hidden-folded d-inline l-s-n-1x align-self-center"><?php echo e(app_name('separated')); ?></span>-->
                    </a>
                    <!-- / brand -->
                </div>
                <div class="card">
                    <div id="content-body">
                        <div class="p-3 p-md-5">
                            <h5>Welcome</h5>
                            <p><small class="text-muted">creat account with us</small></p>
                            <form method="post" role="form" action="<?php echo e(route('user.register_post')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="ref_by" value="<?php echo e($ref_by); ?>">
                                <div class="form-group">
                                    <label>Full Name</label>
                                    <input autocomplete="off" type="text" name="name" class="form-control" placeholder="Enter name" />
                                </div>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input autocomplete="off" type="email" name="email" class="form-control" placeholder="Enter email" />
                                </div>
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input autocomplete="off" type="number" name="phone" class="form-control" placeholder="Enter phone" />
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Password</label>
                                            <input autocomplete="new-password" type="password" name="password" class="form-control" placeholder="Password" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Confirm Pass.</label>
                                            <input autocomplete="new-password" type="password" name="confirm_password" class="form-control" placeholder="Confirm Password" />
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Country</label>
                                    <select id="country" autocomplete="off" type="text" name="country" class="form-control" placeholder="Enter phone" >
                                    </select>
                                </div>
                                <div class="checkbox mb-3">
                                    <label class="ui-check"><input type="checkbox" /><i></i> Remember me</label>
                                </div>
                                <button type="submit" class="btn btn-primary mb-4">Sign up</button>
                                <div>Already registered an account? <a href="<?php echo e(route('user.login')); ?>" class="text-primary">Login</a></div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center text-muted">&copy; Copyright. <?php echo e(app_name('separated')); ?></div>
            </div>
        </div>
        <script src="/assets/js/site.min.js"></script>
        <script type="text/javascript">
            $.getJSON('/json/country.json', function (data) {
                $('#country').append('<option value="">Choose Country</option>');
                $.each(data, function (key, entry) {
                    $('#country').append('<option value="'+ entry.name +'">'+ entry.name +'</option>');
                })
            });
        </script>
    </body>
</html>
<?php /**PATH /home/focsvtdr/allegianceprime-fx.com/castledigital/resources/views/user/register.blade.php ENDPATH**/ ?>