<?php $__env->startSection('content'); ?>
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight"><?php echo e($user->name); ?> Plans</h2>
                                <small class="text-muted">Welcome aboard, <strong><?php echo e(admin()->type); ?></strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Plan</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Amount</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Active</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Duration</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Created on</th>
                                                <th class="text-muted">Expired On</th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            <?php if($user_plans): ?>
                                                <?php $__currentLoopData = $user_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted"><?php echo e($plan->id); ?></small></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted"><?php echo e($plan->name); ?></span></td>
                                                    <td><span class="item-amount text-sm text-muted">$<?php echo e(number_format($plan->amount, 2, '.', ',')); ?></span></td>
                                                    <td class="no-wrap"><div class="item-date text-muted text-sm"><?php echo e($plan->active); ?></div></td>
                                                    <td><span class="item-amount text-muted text-sm"><?php echo e($plan->inv_duration); ?></span></td>
                                                    <td class="no-wrap"><span class="item-amount text-muted text-sm"><?php echo e($plan->activated_at ? \Carbon\Carbon::parse($plan->activated_at)->format('d-m-Y H:ia') : ''); ?></span></td>
                                                    <td class="no-wrap"><span class="item-amount text-muted text-sm"><?php echo e($plan->expire_date ? \Carbon\Carbon::parse($plan->expire_date)->format('d-m-Y H:ia') : ''); ?></span></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fathryzm/public_html/castledigital/resources/views/admin/user_plans.blade.php ENDPATH**/ ?>