<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title><?php echo e(app_name('separated')); ?></title>
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <!-- style -->
        <link rel="icon" type="img/png" href="/logo.png">
        <link rel="stylesheet" href="/assets/css/site.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    </head>
    <body class="layout-row bg-dark">
        <div class="flex">
            <div class="w-xl w-auto-sm mx-auto py-5">
                <?php echo $__env->make('user.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="p-4 d-flex flex-column h-100">
                    <!-- brand -->
                    <a href="https://allegianceprime-fx.com" class="navbar-brand align-self-center">
                         <img src="https://allegianceprime-fx.com/img/logo.png" width="150" height="200">
                       
                    </a>
                    <!-- / brand -->
                </div>
                <div class="card">
                    <div id="content-body">
                        <div class="p-3 p-md-5">
                            <h5>Welcome</h5>
                            <p><small class="text-muted">reset your account password</small></p>
                            <form method="post" role="form" action="<?php echo e(route('user.reset_password_post')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="token" value="<?php echo e($token); ?>">
                                <div class="form-group">
                                    <label>New Password</label>
                                    <input autocomplete="new-password" type="password" name="password" class="form-control" placeholder="New Password" />
                                </div>
                                <div class="form-group">
                                    <label>Confirm New Password</label>
                                    <input autocomplete="new-password" type="password" name="confirm_password" class="form-control" placeholder="Confirm New Password" />
                                </div>
                                <button type="submit" class="btn btn-primary mb-4">Reset Password</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center text-muted">&copy; Copyright. <?php echo e(app_name('separated')); ?></div>
            </div>
        </div>
        <script src="/assets/js/site.min.js"></script>
    </body>
</html>
<?php /**PATH /home/focsvtdr/allegianceprime-fx.com/castledigital/resources/views/user/reset_password.blade.php ENDPATH**/ ?>