<?php $__env->startSection('content'); ?>
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Users KYC</h2>
                                <small class="text-muted">Welcome aboard, <strong><?php echo e(admin()->type); ?></strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        <?php echo $__env->make('admin.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div id="invoice-list" data-plugin="invoice">
                                <div class="toolbar">
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-icon btn-white sort hide" data-sort="item-title" data-toggle="tooltip" title="Sort"><i class="sorting"></i></button>
                                    </div>
                                    <form class="flex" action="">
                                        <div class="input-group">
                                            <input name="search" type="text" class="form-control form-control-theme form-control-sm " placeholder="Search" value="<?php echo e($search); ?>" />
                                            <span class="input-group-append">
                                                <button class="btn btn-white no-border btn-sm" type="submit">
                                                    <span class="d-flex text-muted"><i data-feather="search"></i></span>
                                                </button>
                                            </span>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive" style="min-height: 400px;">
                                    <table class="table table-theme table-row v-middle">
                                        <thead>
                                            <tr>
                                                <th class="text-muted sort sortable" data-sort="id" style="text-align: center;">No.</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Name</th>
                                                <th class="text-muted sort sortable" data-sort="item-company">Email</th>
                                                <th class="text-muted sort sortable" data-sort="item-badge">Status</th>
                                                <th style="width: 50px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody class="list">
                                            <?php if($users): ?>
                                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="v-middle" data-id="2">
                                                    <td style="min-width: 30px; text-align: center;"><small class="text-muted"><?php echo e($user->id); ?></small></td>
                                                    <td><span class="item-badge badge text-uppercase text-muted"><?php echo e($user->name); ?></span></td>
                                                    <td class="no-wrap"><div class="item-date text-muted text-sm"><?php echo e($user->email); ?></div></td>
                                                    <td><span class="item-amount text-muted text-sm"><?php echo e($user->account_verify); ?></span></td>
                                                    <td>
                                                        <div class="item-action dropdown">
                                                            <a href="#" data-toggle="dropdown" class="text-muted"><i data-feather="more-vertical"></i></a>
                                                            <div class="dropdown-menu dropdown-menu-right bg-black" role="menu">
                                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#idModal-<?php echo e($user->id); ?>">View ID</a>
                                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#passportModal-<?php echo e($user->id); ?>">View Passport</a>
                                                                <a class="dropdown-item" href="<?php echo e(route('admin.user_kyc_accept', $user->id)); ?>" onclick="return confirm('are you sure you want to accept this kyc?')">Accept</a>
                                                                <a class="dropdown-item" href="<?php echo e(route('admin.user_kyc_reject', $user->id)); ?>" onclick="return confirm('are you sure you want to reject this kyc?')">Reject</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                <div id="idModal-<?php echo e($user->id); ?>" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md"><?php echo e($user->name); ?> ID</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <img src="<?php echo e(image_url($user->id_card)); ?>" style="width: 100%;">
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                <div id="passportModal-<?php echo e($user->id); ?>" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md"><?php echo e($user->name); ?> Passport</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <img src="<?php echo e(image_url($user->passport)); ?>" style="width: 100%;">
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php if($users): ?>
                                    <?php echo e($users->withQueryString()->links()); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/westzxbr/vanturaholding.com/castledigital/resources/views/admin/user_kyc.blade.php ENDPATH**/ ?>