<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title><?php echo e(app_name('separated')); ?></title>
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <!-- style -->
        <link rel="icon" type="img/png" href="/logo.png">
        <link rel="stylesheet" href="/assets/css/site.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    </head>
    <body class="layout-row">
        <div class="flex">
            <div class="w-xl w-auto-sm mx-auto py-5">
                <?php echo $__env->make('user.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="p-4 d-flex flex-column h-100">
                    <!-- brand -->
                    <a href="javascript:void(0)" class=" align-self-center">
                        <img src="https://tradinginsight-fx.com/img/logo.png" width="200px" height="200px">
                 
                    </a>
                    <!-- / brand -->
                </div>
                <div class="card">
                    <div id="content-body">
                        <div class="p-3 p-md-5">
                            <h5>Welcome</h5>
                            <p><small class="text-muted">verify your email by entering the code sent to your email address</small></p>
                            <form method="post" role="form" action="<?php echo e(route('user.verify_2fa_post')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label>Enter code</label>
                                    <input autocomplete="off" type="text" name="token" class="form-control" placeholder="Enter code here" />
                                </div>
                                <button type="submit" class="btn btn-primary mb-4">Verify code</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center text-muted">&copy; Copyright. <?php echo e(app_name('separated')); ?></div>
            </div>
        </div>
        <script src="/assets/js/site.min.js"></script>
    </body>
</html>
<?php /**PATH /home/premjnqi/tradinginsight-fx.com/castledigital/resources/views/user/verify_2fa.blade.php ENDPATH**/ ?>