<?php $__env->startSection('content'); ?>
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Payment</h2>
                                <small class="text-muted">Welcome aboard, <strong><?php echo e(user()->name); ?></strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        <?php echo $__env->make('user.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div>
                            <h4 class="text-center">You are to make payment of $<?php echo e($amount); ?> using your preferred mode of payment below. Screenshot the proof of payment</h4>
                        </div>
                        <div class="padding">
                            <div id="accordion">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="card">
                                            <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_1">
                                                <img src="/assets/img/bitcoin.png" width="50" height="50">
                                                <div class="px-3"><div>Bitcoin</div></div>
                                            </div>
                                            <div class="collapse p-4" id="c_1">
                                                <?php echo e($setting->btc_address); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="card">
                                            <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_2">
                                                <img src="/assets/img/eth.png" width="50" height="50">
                                                <div class="px-3"><div>Etherium</div></div>
                                            </div>
                                            <div class="collapse p-4" id="c_2">
                                                <?php echo e($setting->eth_address); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="card">
                                            <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_3">
                                                <img src="/assets/img/litecoin.png" width="50" height="50">
                                                <div class="px-3"><div>Litecoin</div></div>
                                            </div>
                                            <div class="collapse p-4" id="c_3">
                                                <?php echo e($setting->ltc_address); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="card">
                                            <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_4">
                                                <img src="/assets/img/dogecoin.png" width="50" height="50">
                                                <div class="px-3"><div>Dodge</div></div>
                                            </div>
                                            <div class="collapse p-4" id="c_4">
                                                <?php echo e($setting->dodge_address); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="card">
                                            <div class="d-flex align-items-center px-4 py-3 b-t pointer" data-toggle="collapse" data-parent="#accordion" data-target="#c_5">
                                                <img src="/assets/img/bnb.png" width="50" height="50">
                                                <div class="px-3"><div>BNB</div></div>
                                            </div>
                                            <div class="collapse p-4" id="c_5">
                                                <?php echo e($setting->bnb_address); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <form method="post" action="<?php echo e(route('user.payment_submit')); ?>" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="amount" value="<?php echo e($amount); ?>">
                                        <div class="row p-2">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Upload Payment proof after payment. (Ignore if paid with card).</label>
                                                    <input type="file" name="proof" class="form-control" accept=".png,.jpg,.jpeg">
                                                </div>
                                                <div class="form-group">
                                                    <label>Payment Mode Used:</label>
                                                    <select type="text" name="payment_mode" class="form-control">
                                                        <option value="Bitcoin">Bitcoin</option>
                                                        <option value="Etherium">Etherium</option>
                                                        <option value="Litecoin">Litecoin</option>
                                                        <option value="Dodgecoin">Dodgecoin</option>
                                                        <option value="BNB">BNB</option>
                                                    </select>
                                                </div>
                                                <button class="btn btn-primary">Submit Payment</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ############ Main END-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/obiajulu/Laravel/Personal Works/castledigital/resources/views/user/payment.blade.php ENDPATH**/ ?>