<?php $__env->startSection('content'); ?>
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Available Plan</h2>
                                <small class="text-muted">Welcome aboard, <strong><?php echo e(admin()->type); ?></strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        <?php echo $__env->make('admin.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <button data-toggle="modal" data-target="#addModal" class="btn btn-primary mb-2"><i class="fas fa-plus"></i> Add new plan</button>
                            <div class="row">
                                <?php if($plans): ?>
                                    <?php $__currentLoopData = $plans->sortBy("price"); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-sm-6">
                                            <div class="card" style="box-shadow: 4px #000000;">
                                                <div class="card-body">
                                                    <h5 class="card-title text-center text-success"><?php echo e($plan->name); ?></h5>
                                                    <h2 class="card-title text-center">$<?php echo e(number_format($plan->price, 2, '.', ',')); ?></h2>
                                                </div>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Possible Deposit:</span> <span>$<?php echo e(number_format($plan->min_price, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Possible Deposit:</span> <span>$<?php echo e(number_format($plan->max_price, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Return:</span> <span>$<?php echo e(number_format($plan->minr, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Return:</span> <span>$<?php echo e(number_format($plan->maxr, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Gift Bonus:</span> <span><?php echo e($plan->gift); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Duration:</span> <span><?php echo e($plan->expiration); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Increment Interval:</span> <span><?php echo e($plan->increment_interval); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Percentage Increase:</span> <span><?php echo e($plan->increment_amount); ?>%</span></li>
                                                </ul>
                                                <div class="card-body text-center">
                                                    <a data-toggle="modal" data-target="#editModal-<?php echo e($plan->id); ?>" href="javascript:void(0)" class="btn btn-primary btn-md"><i class="fas fa-edit"></i></a> 
                                                    <a onclick="return confirm('are you sure you want to delete this plan?')" href="<?php echo e(route('admin.plan_delete', $plan->id)); ?>" class="btn btn-danger btn-md"><i class="fas fa-times"></i></a>
                                                </div>
                                            </div>
                                        </div>
                <div id="editModal-<?php echo e($plan->id); ?>" class="modal fade" data-backdrop="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <div class="modal-title text-md">Edit Plan</div>
                                <button class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="<?php echo e(route('admin.plan_edit')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value="<?php echo e($plan->id); ?>">
                                    <div class="form-group">
                                        <label>Plan Name</label>
                                        <input class="form-control" type="text" name="name" placeholder="Enter Plan name" value="<?php echo e($plan->name); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Price</label>
                                        <input class="form-control" type="text" name="price" placeholder="Enter Plan price" value="<?php echo e($plan->price); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Minimum Price</label>
                                        <input class="form-control" type="text" name="min_price" placeholder="Enter Plan minimum price" value="<?php echo e($plan->min_price); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Maximum Price</label>
                                        <input class="form-control" type="text" name="max_price" placeholder="Enter Plan maximum price" value="<?php echo e($plan->max_price); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Minimum Return</label>
                                        <input class="form-control" type="text" name="minr" placeholder="Enter Plan minimum return" value="<?php echo e($plan->minr); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Plan Maximum Return</label>
                                        <input class="form-control" type="text" name="maxr" placeholder="Enter Plan maximum return" value="<?php echo e($plan->maxr); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Gift Bonus</label>
                                        <input class="form-control" type="text" name="gift" placeholder="Enter Gift bonus" value="<?php echo e($plan->gift); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>To Up Interval</label>
                                        <select class="form-control" type="text" name="increment_interval" value="<?php echo e($plan->increment_interval); ?>">
                                            <option <?php if($plan->increment_interval == 'Monthly'): ?> selected <?php endif; ?> value="Monthly">Monthly</option>
                                            <option <?php if($plan->increment_interval == 'Weekly'): ?> selected <?php endif; ?> value="Weekly">Weekly</option>
                                            <option <?php if($plan->increment_interval == 'Daily'): ?> selected <?php endif; ?> value="Daily">Daily</option>
                                            <option <?php if($plan->increment_interval == 'Hourly'): ?> selected <?php endif; ?> value="Hourly">Hourly</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>To Up Type</label>
                                        <select class="form-control" type="text" name="increment_type" value="<?php echo e($plan->increment_type); ?>">
                                            <option <?php if($plan->increment_type == 'Percentage'): ?> selected <?php endif; ?> value="Percentage">Percentage</option>
                                            <option <?php if($plan->increment_type == 'Fixed'): ?> selected <?php endif; ?> value="Fixed">Fixed</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Top Up Amount (in % or $ as specified above)</label>
                                        <input class="form-control" type="number" step="any" name="increment_amount" placeholder="Enter top up amount" value="<?php echo e($plan->increment_amount); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Investment Duration</label>
                                        <select class="form-control" type="text" name="expiration" value="<?php echo e($plan->expiration); ?>">
                                            <option <?php if($plan->expiration == 'One Week'): ?> selected <?php endif; ?> value="One Week">One Week</option>
                                            <option <?php if($plan->expiration == 'One Month'): ?> selected <?php endif; ?> value="One Month">One Month</option>
                                            <option <?php if($plan->expiration == 'Three Months'): ?> selected <?php endif; ?> value="Three Months">Three Months</option>
                                            <option <?php if($plan->expiration == 'Six Months'): ?> selected <?php endif; ?> value="Six Months">Six Months</option>
                                            <option <?php if($plan->expiration == 'One Year'): ?> selected <?php endif; ?> value="One Year">One Year</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Update Plan</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div id="addModal" class="modal fade" data-backdrop="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <div class="modal-title text-md">Add Plan</div>
                                    <button class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="<?php echo e(route('admin.plan_add')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label>Plan Name</label>
                                            <input class="form-control" type="text" name="name" placeholder="Enter Plan name">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Price</label>
                                            <input class="form-control" type="text" name="price" placeholder="Enter Plan price">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Minimum Price</label>
                                            <input class="form-control" type="text" name="min_price" placeholder="Enter Plan minimum price">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Maximum Price</label>
                                            <input class="form-control" type="text" name="max_price" placeholder="Enter Plan maximum price">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Minimum Return</label>
                                            <input class="form-control" type="text" name="minr" placeholder="Enter Plan minimum return">
                                        </div>
                                        <div class="form-group">
                                            <label>Plan Maximum Return</label>
                                            <input class="form-control" type="text" name="maxr" placeholder="Enter Plan maximum return">
                                        </div>
                                        <div class="form-group">
                                            <label>Gift Bonus</label>
                                            <input class="form-control" type="text" name="gift" placeholder="Enter Gift bonus">
                                        </div>
                                        <div class="form-group">
                                            <label>To Up Interval</label>
                                            <select class="form-control" type="text" name="increment_interval">
                                                <option value="Monthly">Monthly</option>
                                                <option value="Weekly">Weekly</option>
                                                <option value="Daily">Daily</option>
                                                <option value="Hourly">Hourly</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>To Up Type</label>
                                            <select class="form-control" type="text" name="increment_type">
                                                <option value="Percentage">Percentage</option>
                                                <option value="Fixed">Fixed</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Top Up Amount (in % or $ as specified above)</label>
                                            <input class="form-control" type="number" step="any" name="increment_amount" placeholder="Enter top up amount">
                                        </div>
                                        <div class="form-group">
                                            <label>Investment Duration</label>
                                            <select class="form-control" type="text" name="expiration">
                                                <option value="One Week">One Week</option>
                                                <option value="One Month">One Month</option>
                                                <option value="Three Months">Three Months</option>
                                                <option value="Six Months">Six Months</option>
                                                <option value="One Year">One Year</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">Add Plan</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                    </div>
                </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/premjnqi/tradinginsight-fx.com/castledigital/resources/views/admin/plan.blade.php ENDPATH**/ ?>