<?php $__env->startSection('content'); ?>
                <!-- ############ Main START-->
                <div>
                    <div class="page-hero page-container" id="page-hero">
                        <div class="padding d-flex">
                            <div class="page-title">
                                <h2 class="text-md text-highlight">Available Plan</h2>
                                <small class="text-muted">Welcome aboard, <strong><?php echo e(user()->name); ?></strong></small>
                            </div>
                            <div class="flex"></div>
                        </div>
                    </div>
                    <div class="container">
                        <?php echo $__env->make('user.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="page-content page-container" id="page-content">
                        <div class="padding">
                            <div class="row">
                                <?php if($plans): ?>
                                    <?php $__currentLoopData = $plans->sortBy("price"); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-sm-6">
                                            <div class="card" style="box-shadow: 4px #000000;">
                                                <div class="card-body">
                                                    <h5 class="card-title text-center text-success"><?php echo e($plan->name); ?></h5>
                                                    <h2 class="card-title text-center">$<?php echo e(number_format($plan->price, 2, '.', ',')); ?></h2>
                                                </div>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Possible Deposit:</span> <span>$<?php echo e(number_format($plan->min_price, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Possible Deposit:</span> <span>$<?php echo e(number_format($plan->max_price, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Minimum Return:</span> <span>$<?php echo e(number_format($plan->minr, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Maximum Return:</span> <span>$<?php echo e(number_format($plan->maxr, 2, '.', ',')); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Duration:</span> <span><?php echo e($plan->expiration); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Increment Interval:</span> <span><?php echo e($plan->increment_interval); ?></span></li>
                                                    <li class="list-group-item d-flex justify-content-between"><span>Percentage Increase:</span> <span><?php echo e($plan->increment_amount); ?>%</span></li>
                                                </ul>
                                                <div class="card-body text-center">
                                                    <form method="post" action="<?php echo e(route('user.investment_plan_join')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="plan_id" value="<?php echo e($plan->id); ?>">
                                                        <p class="text-center">Amount to invest : default($<?php echo e(number_format($plan->min_price, 2, '.', ',')); ?>)</p>
                                                        <input type="number" name="amount" class="form-control" placeholder="$<?php echo e(number_format($plan->min_price, 2, '.', ',')); ?>" value="<?php echo e($plan->min_price); ?>">
                                                        <button onclick="return confirm('are you sure you want to join this plan?')" class="btn btn-primary mt-1 btn-block">Join plan</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/focsvtdr/allegianceprime-fx.com/castledigital/resources/views/user/investment_plans.blade.php ENDPATH**/ ?>