<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title><?php echo e(app_name('separated')); ?></title>
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <!-- style -->
        <link rel="icon" type="img/png" href="/logo.png">
        <link rel="stylesheet" href="/assets/css/site.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    </head>
    <body class="layout-row">
        <div class="flex">
            <div class="w-xl w-auto-sm mx-auto py-5">
                <?php echo $__env->make('admin.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="p-4 d-flex flex-column h-100">
                    <!-- brand -->
                    <a href="javascript:void(0)" class="navbar-brand align-self-center">
                        <img src="/logo.png" width="32" height="32">
                        <span class="hidden-folded d-inline l-s-n-1x align-self-center"><?php echo e(app_name('separated')); ?></span>
                    </a>
                    <!-- / brand -->
                </div>
                <div class="card">
                    <div id="content-body">
                        <div class="p-3 p-md-5">
                            <h5>Welcome back</h5>
                            <p><small class="text-muted">Login to manage your account</small></p>
                            <form method="post" role="form" action="<?php echo e(route('admin.login_post')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input autocomplete="off" type="email" name="email" class="form-control" placeholder="Enter email" />
                                </div>
                                <div class="form-group">
                                    <label>Password</label>
                                    <input autocomplete="new-password" type="password" name="password" class="form-control" placeholder="Password" />
                                </div>
                                <div class="checkbox mb-3">
                                    <label class="ui-check"><input type="checkbox" /><i></i> Remember me</label>
                                </div>
                                <button type="submit" class="btn btn-primary mb-4">Sign in</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center text-muted">&copy; Copyright. <?php echo e(app_name('separated')); ?></div>
            </div>
        </div>
        <script src="/assets/js/site.min.js"></script>
    </body>
</html>
<?php /**PATH /home/focsvtdr/allegianceprime-fx.com/castledigital/resources/views/admin/login.blade.php ENDPATH**/ ?>